/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.PrimitiveType;

public class UMLPrimitiveTypesUtils {
    private static final String REAL_FRAGMENT = "Real";
    private static final String INTEGER_FRAGMENT = "Integer";
    private static final String STRING_FRAGMENT = "String";
    private static final String BOOL_FRAGMENT = "Boolean";
    private static URI uMLTypesURI = URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
    private static ResourceSet defaultResourceSet = new ResourceSetImpl();

    public static PrimitiveType getReal(EObject context) {
        return UMLPrimitiveTypesUtils.getElement(REAL_FRAGMENT, context);
    }

    public static PrimitiveType getInteger(EObject context) {
        return UMLPrimitiveTypesUtils.getElement(INTEGER_FRAGMENT, context);
    }

    public static PrimitiveType getBoolean(EObject context) {
        return UMLPrimitiveTypesUtils.getElement(BOOL_FRAGMENT, context);
    }

    public static PrimitiveType getString(EObject context) {
        return UMLPrimitiveTypesUtils.getElement(STRING_FRAGMENT, context);
    }

    private static PrimitiveType getElement(String typeFragment, EObject context) {
        ResourceSet resSet = context != null && context.eResource() != null && context.eResource().getResourceSet() != null ? context.eResource().getResourceSet() : defaultResourceSet;
        return (PrimitiveType)resSet.getEObject(uMLTypesURI.appendFragment(typeFragment), true);
    }
}

