/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.moka.trace.capture.CaptureServiceRegistry;
import org.eclipse.papyrus.moka.trace.formater.TraceFileFormaterRegistry;
import org.eclipse.papyrus.moka.trace.interfaces.capture.ICaptureServiceFactory;
import org.eclipse.papyrus.moka.trace.interfaces.format.ITraceFileFormater;
import org.eclipse.papyrus.moka.ui.launch.MokaRunConfigurationTab;
import org.eclipse.papyrus.moka.ui.launch.MokaStringFileSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class MokaTraceServiceComponent
extends Composite {
    protected Button traceCheckBox;
    protected MokaStringFileSelector filePathSelector;
    protected Button traceSelectionButton;
    protected Map<String, Button> captureEngineRadioButtons;
    protected Map<String, List<ITraceFileFormater>> mapCaptureIdToFormatersId;
    protected Map<String, Combo> formaterComboBoxs;
    protected Button traceTracepointModeCheckBox;

    public MokaTraceServiceComponent(Composite parent, int style, String name, int columns) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, false));
        Composite composite = this.createExpandableComposite(parent, name, columns);
        this.formaterComboBoxs = new HashMap<String, Combo>();
        this.createCheckbox(composite);
        this.createFilePathText(composite);
        this.createFileFormatList(composite);
        this.createTracepointModeCheckbox(composite);
    }

    protected Composite createExpandableComposite(Composite parent, String name, int columns) {
        final ExpandableComposite expandableComposite = new ExpandableComposite(parent, 18);
        expandableComposite.setText(name);
        expandableComposite.setExpanded(false);
        expandableComposite.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                expandableComposite.getParent().getParent().layout();
                expandableComposite.getParent().getParent().redraw();
            }
        });
        Group composite = new Group((Composite)expandableComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        expandableComposite.setClient((Control)composite);
        return composite;
    }

    protected void createCheckbox(Composite parent) {
        this.traceCheckBox = new Button(parent, 32);
        this.traceCheckBox.setEnabled(true);
        this.traceCheckBox.setText("Generate trace file");
    }

    protected void createFilePathText(Composite parent) {
        this.filePathSelector = new MokaStringFileSelector(parent, 0, "Trace file path", this.getDefaultFileName());
        this.filePathSelector.setLayoutData(new GridData(4, 1, true, false));
    }

    protected void createFileFormatList(Composite parent) {
        Group fileFormatGroup = new Group(parent, 0);
        fileFormatGroup.setText("File format output");
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 4;
        fileFormatGroup.setLayout((Layout)gridLayout);
        fileFormatGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Map captureEngine = CaptureServiceRegistry.INSTANCE.getCaptureServices();
        this.captureEngineRadioButtons = new LinkedHashMap<String, Button>();
        this.mapCaptureIdToFormatersId = new HashMap<String, List<ITraceFileFormater>>();
        Collection formaters = TraceFileFormaterRegistry.INSTANCE.getTraceFileFormater();
        for (Map.Entry capture : captureEngine.entrySet()) {
            ArrayList<ITraceFileFormater> formaterList = new ArrayList<ITraceFileFormater>();
            for (ITraceFileFormater formater : formaters) {
                if (!formater.getCaptureId().equals(capture.getKey())) continue;
                formaterList.add(formater);
            }
            this.mapCaptureIdToFormatersId.put((String)capture.getKey(), formaterList);
        }
        for (Map.Entry capture : captureEngine.entrySet()) {
            Button button = new Button((Composite)fileFormatGroup, 16);
            button.setText(((ICaptureServiceFactory)capture.getValue()).getName());
            this.captureEngineRadioButtons.put((String)capture.getKey(), button);
            this.addFormaterComboBox((Composite)fileFormatGroup, (String)capture.getKey());
        }
    }

    protected void addFormaterComboBox(Composite parent, String captureId) {
        Combo combo = new Combo(parent, 4);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        combo.setEnabled(true);
        this.mapCaptureIdToFormatersId.get(captureId).stream().forEach(formater -> combo.add(formater.getName()));
        if (combo.getItemCount() != 0) {
            combo.select(0);
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ITraceFileFormater formater;
                if (e.getSource() instanceof Combo && (formater = MokaTraceServiceComponent.this.getFormaterFromComboBox((Combo)e.getSource())) != null) {
                    MokaTraceServiceComponent.this.filePathSelector.setFileExtension(formater.getFileExtension());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.formaterComboBoxs.put(captureId, combo);
    }

    protected ITraceFileFormater getFormaterFromComboBox(Combo combo) {
        int selection = combo.getSelectionIndex();
        String formaterName = combo.getItem(selection);
        ITraceFileFormater formater = null;
        for (Map.Entry<String, List<ITraceFileFormater>> entry : this.mapCaptureIdToFormatersId.entrySet()) {
            formater = entry.getValue().stream().filter(f -> f.getName().equals(formaterName)).findFirst().orElse(null);
            if (formater == null) continue;
            return formater;
        }
        return formater;
    }

    protected void createTracepointModeCheckbox(Composite parent) {
        this.traceTracepointModeCheckBox = new Button(parent, 32);
        this.traceTracepointModeCheckBox.setEnabled(true);
        this.traceTracepointModeCheckBox.setText("Tracepoint mode");
        this.traceTracepointModeCheckBox.setToolTipText("When the tracepoint mode is activate, only nodes which have a tracepoint marker are traced (right click on the node, tracing, add tracepoint)");
    }

    public String getFilePath() {
        return this.filePathSelector.getText().getText();
    }

    public void setFilePath(String text) {
        this.filePathSelector.getText().setText(text);
    }

    private String getDefaultFileName() {
        return "trace";
    }

    public ICaptureServiceFactory getCaptureServiceFactory() {
        String captureID = this.getCaptureId();
        if (captureID != null) {
            return CaptureServiceRegistry.INSTANCE.getCaptureService(captureID);
        }
        return null;
    }

    protected String getCaptureId() {
        String captureID = null;
        for (Map.Entry<String, Button> captureEntry : this.captureEngineRadioButtons.entrySet()) {
            if (!captureEntry.getValue().getSelection()) continue;
            captureID = captureEntry.getKey();
            break;
        }
        return captureID;
    }

    public ITraceFileFormater getFormater() {
        String captureID = this.getCaptureId();
        if (captureID != null) {
            Combo combo = this.formaterComboBoxs.get(captureID);
            List<ITraceFileFormater> comboFormaterRef = this.mapCaptureIdToFormatersId.get(captureID);
            ITraceFileFormater formater = comboFormaterRef.get(combo.getSelectionIndex());
            return formater;
        }
        return null;
    }

    public void setFormaterFromID(String id) {
        ITraceFileFormater formater = TraceFileFormaterRegistry.INSTANCE.getFormaterFromID(id);
        if (formater != null) {
            String captureId = formater.getCaptureId();
            this.captureEngineRadioButtons.get(captureId).setSelection(true);
            List<ITraceFileFormater> formaterList = this.mapCaptureIdToFormatersId.get(captureId);
            int index = formaterList.indexOf(formater);
            this.formaterComboBoxs.get(captureId).select(index);
            if (this.filePathSelector != null) {
                this.filePathSelector.setFileExtension(formater.getFileExtension());
            }
        } else {
            Iterator<Button> iterator = this.captureEngineRadioButtons.values().iterator();
            if (iterator.hasNext()) {
                Button button = iterator.next();
                button.setSelection(true);
            }
        }
        this.enabledComboBoxs();
    }

    protected void enabledComboBoxs() {
        for (Map.Entry<String, Button> button : this.captureEngineRadioButtons.entrySet()) {
            Combo combo = this.formaterComboBoxs.get(button.getKey());
            if (button.getValue().getSelection()) {
                combo.setEnabled(true);
                ITraceFileFormater formater = this.getFormaterFromComboBox(combo);
                if (formater == null) continue;
                this.filePathSelector.setFileExtension(formater.getFileExtension());
                continue;
            }
            combo.setEnabled(false);
        }
    }

    public void enableTraceWidget(boolean enable) {
        this.filePathSelector.setReadOnly(!enable);
        this.captureEngineRadioButtons.values().stream().forEach(button -> button.setEnabled(enable));
        if (enable) {
            this.enabledComboBoxs();
        } else {
            this.formaterComboBoxs.values().stream().forEach(combo -> combo.setEnabled(false));
        }
        this.traceTracepointModeCheckBox.setEnabled(enable);
    }

    public void addRadioListener(final MokaRunConfigurationTab tab) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tab.updateLaunchConfigurationDialog();
                MokaTraceServiceComponent.this.enabledComboBoxs();
                if (e.getSource() instanceof Button) {
                    Button button = (Button)e.getSource();
                    Map.Entry captureIdEntry = MokaTraceServiceComponent.this.captureEngineRadioButtons.entrySet().stream().filter(entry -> ((Button)entry.getValue()).equals(button)).findFirst().orElse(null);
                    Combo formaterCombo = MokaTraceServiceComponent.this.formaterComboBoxs.get(captureIdEntry.getKey());
                    ITraceFileFormater formater = MokaTraceServiceComponent.this.getFormaterFromComboBox(formaterCombo);
                    if (formater != null) {
                        MokaTraceServiceComponent.this.filePathSelector.setFileExtension(formater.getFileExtension());
                    }
                }
            }
        };
        this.captureEngineRadioButtons.values().stream().forEach(button -> button.addSelectionListener((SelectionListener)selectionAdapter));
    }

    public void addTracePointModeListner(final MokaRunConfigurationTab tab) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tab.updateLaunchConfigurationDialog();
            }
        };
        this.traceTracepointModeCheckBox.addSelectionListener((SelectionListener)selectionAdapter);
    }

    public static boolean shouldDisplay() {
        return !CaptureServiceRegistry.INSTANCE.getCaptureServices().isEmpty();
    }
}

