/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.moka.animation.css.MokaCSSDiagram;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineDebugTarget;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.engine.EngineRegistry;
import org.eclipse.papyrus.moka.kernel.process.ExecutionEngineProcess;
import org.eclipse.papyrus.moka.kernel.process.MQTTServerConfig;
import org.eclipse.papyrus.moka.kernel.process.ServerMqttProcess;
import org.eclipse.papyrus.moka.launch.ExecutionEngineLaunchConfigurationReader;
import org.eclipse.papyrus.moka.launch.IExecutionEngineLaunchConfigurationReader;
import org.eclipse.papyrus.moka.launch.MokaErrorDialog;
import org.eclipse.papyrus.moka.ui.Messages;
import org.eclipse.papyrus.moka.ui.MokaUIActivator;
import org.eclipse.papyrus.moka.ui.validation.ValidationUtil;
import org.eclipse.papyrus.moka.utils.helper.PapyrusEditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ExecutionEngineLaunchDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected IProject project;
    private EngineConfiguration<?> engineConfiguration;
    private ModelSet modelSet;

    private boolean canOpenProject(IExecutionEngineLaunchConfigurationReader reader) {
        IProject p;
        boolean isOpen = false;
        if (reader != null && (p = reader.getProject()) != null) {
            isOpen = p.isOpen();
        }
        return isOpen;
    }

    private boolean canInstantiateEngine(IExecutionEngineLaunchConfigurationReader reader) {
        boolean engineInstantiated = false;
        if (reader != null) {
            engineInstantiated = reader.getEngine() != null;
        }
        return engineInstantiated;
    }

    private boolean canRunServer() {
        boolean canRunServer = false;
        canRunServer = !MQTTServerConfig.getMQTTServerPath().isEmpty() && Integer.parseInt(MQTTServerConfig.getMQTTServerPort()) > 0;
        return canRunServer;
    }

    private boolean isValidationOk(EngineConfiguration<?> engineConfiguration, IProgressMonitor monitor, String engineID) {
        IPreferenceStore store = MokaUIActivator.getDefault().getPreferenceStore();
        boolean mustValidate = store.getBoolean("MODEL_VALIDATION_ON_LAUNCH");
        boolean continueSimulation = true;
        if (mustValidate) {
            continueSimulation = ValidationUtil.validateModel(engineConfiguration, monitor, engineID);
        }
        return continueSimulation;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.modelSet = null;
        this.engineConfiguration = null;
        boolean prechecks = false;
        EngineRegistry.getInstance().loadEngines();
        IExecutionEngineLaunchConfigurationReader reader = this.createReader(configuration);
        if (this.canOpenProject(reader)) {
            this.project = reader.getProject();
            if (this.canInstantiateEngine(reader)) {
                this.initMQTTServerConfig();
                if (this.canRunServer()) {
                    SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    IExecutionEngineLaunchConfigurationReader cr = this.createReader(configuration);
                    this.modelSet = this.initializeModelingEnvironment(cr, progressMonitor.split(2));
                    if (this.modelSet != null) {
                        this.engineConfiguration = this.createConfiguration(cr, this.modelSet);
                        if (this.isValidationOk(this.engineConfiguration, (IProgressMonitor)progressMonitor, reader.getExecutionEngineID())) {
                            prechecks = true;
                        }
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = Display.getDefault().getActiveShell();
                                Status status = new Status(4, "org.eclipse.papyrus.moka.ui", Messages.ModelSetOpenning_Status);
                                MokaErrorDialog dialog = new MokaErrorDialog(shell, Messages.MokaDialogError_Title, Messages.ModelSetOpenning_Title, (IStatus)status, 4);
                                dialog.open();
                            }
                        });
                    }
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = Display.getDefault().getActiveShell();
                            Status status = new Status(4, "org.eclipse.papyrus.moka.ui", Messages.ServerError_Status);
                            MokaErrorDialog dialog = new MokaErrorDialog(shell, Messages.MokaDialogError_Title, Messages.ServerError_Title, (IStatus)status, 4);
                            dialog.open();
                            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.papyrus.moka.ui.preferences", null, null).open();
                        }
                    });
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        Status status = new Status(4, "org.eclipse.papyrus.moka.ui", Messages.EngineInstantiationError_Status);
                        MokaErrorDialog dialog = new MokaErrorDialog(shell, Messages.MokaDialogError_Title, Messages.EngineInstantiationError_Title, (IStatus)status, 4);
                        dialog.open();
                    }
                });
            }
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = Display.getDefault().getActiveShell();
                    Status status = new Status(4, "org.eclipse.papyrus.moka.ui", Messages.ProjectOpeningError_Status);
                    MokaErrorDialog dialog = new MokaErrorDialog(shell, Messages.MokaDialogError_Title, Messages.ProjectOpeningError_Title, (IStatus)status, 4);
                    dialog.open();
                }
            });
        }
        return prechecks;
    }

    protected void initMQTTServerConfig() {
        MQTTServerConfig.setMQTTServerPath((String)MokaUIActivator.getDefault().getPreferenceStore().getString("MQTT_SERVER_PATH"));
        MQTTServerConfig.setMQTTServerPort((String)MokaUIActivator.getDefault().getPreferenceStore().getString("MQTT_SERVER_PORT"));
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IExecutionEngineLaunchConfigurationReader cr = this.createReader(configuration);
        if (this.modelSet == null) {
            this.modelSet = this.initializeModelingEnvironment(cr, progressMonitor.split(2));
        }
        if (this.modelSet != null && this.engineConfiguration != null) {
            this.engineConfiguration = this.createConfiguration(cr, this.modelSet);
        }
        if (this.modelSet != null && this.engineConfiguration != null) {
            ServerMqttProcess serverProcess = new ServerMqttProcess(launch);
            serverProcess.run();
            if (!serverProcess.isTerminated()) {
                ExecutionEngineProcess engineProcess = this.initializeExecutionProcess(launch, cr, this.engineConfiguration);
                Iterable diagrams = NotationUtils.getAllNotations((ResourceSet)this.modelSet, MokaCSSDiagram.class);
                Job job = (Job)engineProcess.getProcess();
                if (job != null) {
                    diagrams.forEach(d -> job.addJobChangeListener((IJobChangeListener)d.getEngine()));
                }
                if (engineProcess != null) {
                    engineProcess.run();
                }
            } else {
                MokaUIActivator.getDefault().getLogger().error("Server execution failed", (Throwable)serverProcess.getError());
            }
        } else {
            MokaUIActivator.getDefault().getLogger().error("Modeling environment could not be initialized", null);
        }
    }

    protected IExecutionEngineLaunchConfigurationReader createReader(ILaunchConfiguration configuration) {
        return new ExecutionEngineLaunchConfigurationReader(configuration);
    }

    protected EngineConfiguration<?> createConfiguration(IExecutionEngineLaunchConfigurationReader cr, ModelSet ms) {
        EngineConfiguration ec = new EngineConfiguration();
        ec.setProject(this.project);
        ec.setModelURI(cr.getModelURI());
        Resource resource = ms.getResource(cr.getModelURI(), true);
        if (resource != null) {
            ec.setExecutionSource(resource.getEObject(cr.getExecutionSourceURI().toString()));
        }
        ec.setTraceEnabled(cr.isTraceServiceEnabled());
        ec.setTraceFilePath(cr.getTraceFile());
        ec.setFormatterID(cr.getTraceFormatterID());
        ec.setTracepointMode(cr.isTracePointMode());
        return ec;
    }

    protected final ModelSet initializeModelingEnvironment(IExecutionEngineLaunchConfigurationReader configurationReader, SubMonitor monitor) {
        ServicesRegistry registry;
        if (!PapyrusEditorUtils.isProjectOpen((URI)configurationReader.getModelDIURI()) | !PapyrusEditorUtils.isEditorActivated((URI)configurationReader.getModelDIURI())) {
            PapyrusEditorUtils.openProject((IProject)this.project, (URI)configurationReader.getModelDIURI());
        }
        monitor.worked(1);
        ModelSet modelSet = null;
        IEditorPart editor = PapyrusEditorUtils.getEditor((URI)configurationReader.getModelDIURI());
        if (editor != null && (registry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class)) != null) {
            try {
                modelSet = (ModelSet)registry.getService(ModelSet.class);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        monitor.worked(1);
        return modelSet;
    }

    protected final ExecutionEngineProcess initializeExecutionProcess(ILaunch l, IExecutionEngineLaunchConfigurationReader cr, EngineConfiguration<? extends EObject> ec) {
        ExecutionEngineProcess process = new ExecutionEngineProcess(l, cr.getEngine(), ec);
        ExecutionEngineDebugTarget debugTarget = new ExecutionEngineDebugTarget(l, process);
        l.addProcess((IProcess)process);
        l.addDebugTarget((IDebugTarget)debugTarget);
        return process;
    }
}

