/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.moka.kernel.engine.EngineRegistry;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.launch.IExecutionEngineLaunchConfigurationReader;

public class ExecutionEngineLaunchConfigurationReader
implements IExecutionEngineLaunchConfigurationReader {
    private static final String DEFAULT_VALUE_STRING = "";
    public static String MODEL_URI_ATTRIBUTE_NAME = "URI_ATTRIBUTE";
    public static String MODEL_ELEMENT_URI_ATTRIBUTE_NAME = "FRAGMENT_ATTRIBUTE";
    public static final String EXECUTION_ENGINE_ATTRIBUTE_NAME = "EXECUTION_ENGINE_ATTRIBUTE";
    public static final String MOKA_TRACE_FILE_PATH = "MOKA_TRACE_FILE_PATH";
    public static final String MOKA_TRACE_FORMATER = "MOKA_TRACE_FORMATER";
    public static final String MOKA_TRACE_SERVICE_ACTIVATE = "MOKA_TRACE_SERVICE_ACTIVATE";
    public static final String MOKA_TRACE_TRACEPOINT_MODE = "MOKA_TRACE_TRACEPOINT_MODE";
    protected ILaunchConfiguration configuration;

    public ExecutionEngineLaunchConfigurationReader(ILaunchConfiguration c) {
        this.configuration = c;
    }

    public void setConfiguration(ILaunchConfiguration c) {
        this.configuration = c;
    }

    @Override
    public IProject getProject() {
        IWorkspaceRoot workspaceRoot;
        IFile file;
        IProject project = null;
        URI uri = this.getModelURI();
        if (uri != null && (file = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getFile((IPath)new Path(uri.toPlatformString(true)))) != null && file.exists()) {
            project = file.getProject();
        }
        return project;
    }

    @Override
    public IExecutionEngine getEngine() {
        return EngineRegistry.getInstance().getEngine(this.getExecutionEngineID());
    }

    @Override
    public URI getModelDIURI() {
        URI uri = null;
        URI modelURI = this.getModelURI();
        if (modelURI != null && !modelURI.isEmpty() && "uml".equals(modelURI.fileExtension())) {
            uri = modelURI.trimFileExtension();
            uri = uri.appendFileExtension("di");
        }
        return uri;
    }

    @Override
    public URI getModelURI() {
        URI uri = null;
        if (this.configuration != null) {
            try {
                uri = URI.createURI((String)this.configuration.getAttribute(MODEL_URI_ATTRIBUTE_NAME, DEFAULT_VALUE_STRING));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return uri;
    }

    @Override
    public URI getExecutionSourceURI() {
        URI uri = null;
        if (this.configuration != null) {
            try {
                uri = URI.createURI((String)this.configuration.getAttribute(MODEL_ELEMENT_URI_ATTRIBUTE_NAME, DEFAULT_VALUE_STRING));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return uri;
    }

    @Override
    public String getExecutionEngineID() {
        String engineID = null;
        if (this.configuration != null) {
            try {
                engineID = this.configuration.getAttribute(EXECUTION_ENGINE_ATTRIBUTE_NAME, DEFAULT_VALUE_STRING);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return engineID;
    }

    @Override
    public String getTraceFile() {
        String traceFile = null;
        if (this.configuration != null) {
            try {
                traceFile = this.configuration.getAttribute(MOKA_TRACE_FILE_PATH, DEFAULT_VALUE_STRING);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return traceFile;
    }

    @Override
    public String getTraceFormatterID() {
        String traceFormatterID = null;
        if (this.configuration != null) {
            try {
                traceFormatterID = this.configuration.getAttribute(MOKA_TRACE_FORMATER, DEFAULT_VALUE_STRING);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return traceFormatterID;
    }

    @Override
    public boolean isTraceServiceEnabled() {
        boolean enabled = false;
        if (this.configuration != null) {
            try {
                enabled = this.configuration.getAttribute(MOKA_TRACE_SERVICE_ACTIVATE, false);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return enabled;
    }

    @Override
    public boolean isTracePointMode() {
        boolean tracepointMode = false;
        if (this.configuration != null) {
            try {
                tracepointMode = this.configuration.getAttribute(MOKA_TRACE_TRACEPOINT_MODE, false);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return tracepointMode;
    }
}

