/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.target;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngine;
import org.eclipse.papyrus.moka.debug.messages.ThreadRequest;
import org.eclipse.papyrus.moka.debug.target.DebugElementStatus;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineDebugElement;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineDebugTargetClient;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineThread;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTarget;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTargetClient;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineThread;
import org.eclipse.papyrus.moka.kernel.process.ExecutionEngineProcess;
import org.eclipse.papyrus.moka.kernel.process.MQTTServerConfig;

public class ExecutionEngineDebugTarget
extends ExecutionEngineDebugElement
implements IExecutionEngineDebugTarget {
    private static final String DEBUG_TARGET_NAME = "UML Execution Engine Debug Target";
    protected ILaunch launch;
    protected ExecutionEngineProcess process;
    protected ExecutionEngineDebugTargetClient client;
    protected Map<String, ExecutionEngineThread> threadMap;
    protected ReentrantLock threadLock;

    public ExecutionEngineDebugTarget(ILaunch l, ExecutionEngineProcess p) {
        super(null);
        this.launch = l;
        this.process = p;
        this.threadMap = new HashMap<String, ExecutionEngineThread>();
        this.threadLock = new ReentrantLock(true);
        this.status = DebugElementStatus.RUNNING;
        this.statusLock = new ReentrantLock(true);
        this.initClient();
        this.fireCreationEvent();
    }

    private void initClient() {
        String port = MQTTServerConfig.getMQTTServerPort();
        this.client = new ExecutionEngineDebugTargetClient("tcp://localhost:" + port, "Debug Target", this);
        this.client.run();
    }

    @Override
    public IDebuggableExecutionEngine<?, ?> getExecutionEngine() {
        if (this.process != null) {
            return (IDebuggableExecutionEngine)this.process.getExecutionEngine();
        }
        return null;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean canResume() {
        return !this.isDisconnected() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isDisconnected() && !this.isSuspended();
    }

    public boolean isSuspended() {
        boolean suspended = false;
        if (!this.isDisconnected()) {
            if (!this.threadLock.isHeldByCurrentThread()) {
                this.threadLock.lock();
            }
            Iterator<Map.Entry<String, ExecutionEngineThread>> it = this.threadMap.entrySet().iterator();
            suspended = it.hasNext();
            while (suspended && it.hasNext()) {
                suspended &= it.next().getValue().isSuspended();
            }
            if (this.threadLock.isHeldByCurrentThread()) {
                this.threadLock.unlock();
            }
        }
        return suspended;
    }

    public void suspend() throws DebugException {
        this.threadLock.lock();
        for (Map.Entry<String, ExecutionEngineThread> entry : this.threadMap.entrySet()) {
            if (!entry.getValue().canSuspend()) continue;
            entry.getValue().suspend();
        }
        this.threadLock.unlock();
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public void resume() throws DebugException {
        this.threadLock.lock();
        for (Map.Entry<String, ExecutionEngineThread> entry : this.threadMap.entrySet()) {
            if (!entry.getValue().canResume()) continue;
            entry.getValue().resume();
        }
        this.threadLock.unlock();
        this.setStatus(DebugElementStatus.RUNNING);
        this.fireResumeEvent(32);
    }

    public boolean canTerminate() {
        return !this.isDisconnected() && !this.isTerminated() | this.isSuspended();
    }

    public boolean isTerminated() {
        boolean isTerminated = false;
        if (!this.isDisconnected()) {
            Iterator<Map.Entry<String, ExecutionEngineThread>> it;
            if (!this.threadLock.isHeldByCurrentThread()) {
                this.threadLock.lock();
            }
            isTerminated = !(it = this.threadMap.entrySet().iterator()).hasNext();
            while (isTerminated && it.hasNext()) {
                isTerminated &= it.next().getValue().isTerminated();
            }
            if (this.threadLock.isHeldByCurrentThread()) {
                this.threadLock.unlock();
            }
        }
        return isTerminated;
    }

    public void terminate() throws DebugException {
        if (this.isSuspended()) {
            this.resume();
        }
        if (!this.threadLock.isHeldByCurrentThread()) {
            this.threadLock.lock();
        }
        ArrayList<String> removed = new ArrayList<String>();
        for (Map.Entry<String, ExecutionEngineThread> entry : this.threadMap.entrySet()) {
            removed.add(entry.getKey());
            entry.getValue().terminate();
        }
        if (this.threadLock.isHeldByCurrentThread()) {
            this.threadLock.unlock();
        }
    }

    @Override
    public void handleTargetTerminateEvent() {
        this.threadLock.lock();
        for (Map.Entry<String, ExecutionEngineThread> entry : this.threadMap.entrySet()) {
            ExecutionEngineThread thread = entry.getValue();
            thread.setStatus(DebugElementStatus.TERMINATED);
            thread.fireTerminateEvent();
        }
        this.threadMap.clear();
        this.threadLock.unlock();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (ExecutionEngineDebugTarget.this.canDisconnect()) {
                    try {
                        ExecutionEngineDebugTarget.this.disconnect();
                    }
                    catch (DebugException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        this.fireChangeEvent(512);
    }

    public boolean canDisconnect() {
        return this.client != null && this.client.isConnected();
    }

    public void disconnect() throws DebugException {
        if (this.isSuspended()) {
            this.resume();
        }
        this.client.terminate();
        if (!this.client.isConnected()) {
            this.threadLock.lock();
            this.threadMap.clear();
            this.threadLock.unlock();
            this.fireChangeEvent(512);
        }
    }

    public boolean isDisconnected() {
        return this.client != null && !this.client.isConnected();
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] thread = null;
        this.threadLock.lock();
        thread = this.threadMap.values().toArray(new IExecutionEngineThread[0]);
        this.threadLock.unlock();
        return thread;
    }

    public boolean hasThreads() throws DebugException {
        boolean hasThread = false;
        this.threadLock.lock();
        hasThread = !this.threadMap.isEmpty();
        this.threadLock.unlock();
        return hasThread;
    }

    public boolean hasSuspendedThreads() {
        boolean hasSuspendedThread = true;
        this.threadLock.lock();
        Iterator<ExecutionEngineThread> it = this.threadMap.values().iterator();
        while (!hasSuspendedThread && it.hasNext()) {
            hasSuspendedThread = it.next().getStatus().equals((Object)DebugElementStatus.SUSPENDED);
        }
        this.threadLock.unlock();
        return hasSuspendedThread;
    }

    public String getName() throws DebugException {
        return DEBUG_TARGET_NAME;
    }

    @Override
    public void handleTargetThreadCreateEvent(ThreadRequest request) {
        ExecutionEngineThread thread = this.getThread(request.getThreadId());
        if (thread == null) {
            thread = new ExecutionEngineThread(this.getDebugTarget());
            thread.setID(request.getThreadId());
            this.threadLock.lock();
            this.threadMap.put(request.getThreadId(), thread);
            this.threadLock.unlock();
            thread.fireCreationEvent();
            this.fireChangeEvent(512);
        }
    }

    @Override
    public void handleTargetThreadTerminateEvent(ThreadRequest request) {
        ExecutionEngineThread thread = this.getThread(request.getThreadId());
        if (thread != null) {
            this.threadLock.lock();
            this.threadMap.remove(thread.getID());
            this.threadLock.unlock();
            thread.fireTerminateEvent();
            this.fireChangeEvent(512);
        }
    }

    @Override
    public ExecutionEngineThread getThread(String threadId) {
        ExecutionEngineThread thread = null;
        this.threadLock.lock();
        thread = this.threadMap.get(threadId);
        this.threadLock.unlock();
        return thread;
    }

    @Override
    public IExecutionEngineDebugTargetClient getClient() {
        return this.client;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }
}

