/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.css;

import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusDiagramEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.GMFElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.DiagramCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.w3c.dom.Element;

public class MokaDiagramCSSEngine
extends DiagramCSSEngine
implements IJobChangeListener {
    private static boolean isMokaProcessRunning = false;

    public MokaDiagramCSSEngine(ExtendedCSSEngine parent, CSSDiagram diagram) {
        super(parent, diagram);
    }

    public void notifyChange(Element elementAdapter) {
        if (isMokaProcessRunning) {
            this.resetCache();
            Diagram diagram = (Diagram)PlatformHelper.getAdapter((Object)elementAdapter, Diagram.class);
            Set diagramEditParts = PapyrusDiagramEditPart.getDiagramEditPartsFor((Diagram)diagram);
            if (!diagramEditParts.isEmpty()) {
                GMFElementAdapter tmp;
                View notationElemntTorefresh;
                EditPart editPart;
                if (elementAdapter instanceof GMFElementAdapter && (editPart = DiagramEditPartsUtil.getEditPartFromView((View)(notationElemntTorefresh = (tmp = (GMFElementAdapter)elementAdapter).getNotationElement()), (EditPart)((EditPart)diagramEditParts.iterator().next()))) instanceof IPrimaryEditPart) {
                    DiagramHelper.asyncExec((DiagramEditPart)((DiagramEditPart)diagramEditParts.iterator().next()), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DiagramHelper.refresh((EditPart)editPart, (boolean)true);
                        }
                    });
                }
            } else {
                DiagramHelper.scheduleRefresh();
            }
        } else {
            super.notifyChange(elementAdapter);
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        isMokaProcessRunning = false;
    }

    public void running(IJobChangeEvent event) {
        isMokaProcessRunning = true;
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

