/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.actions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.activities.ControlNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.ForkedToken;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IForkNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IObjectNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ObjectNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;

public class ForkNodeActivation
extends ControlNodeActivation
implements IForkNodeActivation {
    @Override
    public void fire(List<IToken> incomingTokens) {
        if (this.getNode() == null) {
            Debug.println("[fire] Anonymous fork node.");
        } else {
            Debug.println("[fire] Fork node " + this.getNode().getName() + "...");
        }
        List<IActivityEdgeInstance> outgoingEdges = this.getOutgoingEdges();
        int outgoingEdgeCount = outgoingEdges.size();
        ArrayList<IToken> forkedTokens = new ArrayList<IToken>();
        int i = 0;
        while (i < incomingTokens.size()) {
            IToken token = incomingTokens.get(i);
            ForkedToken forkedToken = new ForkedToken();
            forkedToken.setBaseToken(token);
            forkedToken.setRemainingOffersCount(outgoingEdgeCount);
            forkedToken.setBaseTokenWithDrawn(false);
            forkedTokens.add(forkedToken);
            ++i;
        }
        ArrayList<IToken> arrayList = forkedTokens;
        ForkNodeActivation forkNodeActivation = this;
        try {
            forkNodeActivation.addTokens(arrayList);
        }
        finally {
            if (forkNodeActivation instanceof IPinActivation) {
                PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$1$44250678((IPinActivation)forkNodeActivation, arrayList);
            }
        }
        ArrayList<IToken> arrayList2 = forkedTokens;
        ForkNodeActivation forkNodeActivation2 = this;
        if (forkNodeActivation2 instanceof IObjectNodeActivation) {
            ObjectNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ObjectNodeActivationProfiler$1$8827a211((IObjectNodeActivation)forkNodeActivation2, arrayList2);
        }
        forkNodeActivation2.sendOffers(arrayList2);
    }

    @Override
    public void terminate() {
        this.clearTokens();
        super.terminate();
    }
}

