/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.actions.IActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IExpansionNodeActivation;
import org.eclipse.papyrus.moka.fuml.actions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.actions.IStructuredActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.ActivityParameterNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IActivityExecution;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IActivityParameterNodeActivation;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.Pin;

public class ActivityNodeActivationGroup
implements IActivityNodeActivationGroup {
    public List<IActivityEdgeInstance> edgeInstances = new ArrayList<IActivityEdgeInstance>();
    public List<IActivityNodeActivation> nodeActivations = new ArrayList<IActivityNodeActivation>();
    public IActivityExecution activityExecution;
    public IStructuredActivityNodeActivation containingNodeActivation;
    public List<IActivityNodeActivation> suspendedActivations = new ArrayList<IActivityNodeActivation>();

    public void run(List<IActivityNodeActivation> activations) {
        int i = 0;
        while (i < activations.size()) {
            IActivityNodeActivation activation = activations.get(i);
            activation.run();
            ++i;
        }
        Debug.println("[run] Checking for enabled nodes...");
        ArrayList<IActivityNodeActivation> enabledParameterNodeActivations = new ArrayList<IActivityNodeActivation>();
        ArrayList<IActivityNodeActivation> enabledOtherActivations = new ArrayList<IActivityNodeActivation>();
        int i2 = 0;
        while (i2 < activations.size()) {
            IActivityNodeActivation activation = activations.get(i2);
            Debug.println("[run] Checking node " + activation.getNode().getName() + "...");
            if (!(activation instanceof IPinActivation | activation instanceof IExpansionNodeActivation)) {
                boolean isEnabled = this.checkIncomingEdges(activation.getIncomingEdges(), activations);
                if (isEnabled & activation instanceof IActionActivation) {
                    EList inputPins = ((Action)activation.getNode()).getInputs();
                    int j = 1;
                    while (j <= inputPins.size() & isEnabled) {
                        InputPin inputPin = (InputPin)inputPins.get(j - 1);
                        List inputEdges = ((IActionActivation)activation).getPinActivation((Pin)inputPin).getIncomingEdges();
                        isEnabled = this.checkIncomingEdges(inputEdges, activations);
                        ++j;
                    }
                }
                if (isEnabled) {
                    Debug.println("[run] Node " + activation.getNode().getName() + " is enabled.");
                    if (activation instanceof ActivityParameterNodeActivation) {
                        enabledParameterNodeActivations.add(activation);
                    } else {
                        enabledOtherActivations.add(activation);
                    }
                }
            }
            ++i2;
        }
        for (IActivityNodeActivation activation : enabledParameterNodeActivations) {
            activation.receiveOffer();
        }
        for (IActivityNodeActivation activation : enabledOtherActivations) {
            Debug.println("[run] Sending offer to node " + activation.getNode().getName() + ".");
            activation.receiveOffer();
        }
    }

    public Boolean checkIncomingEdges(List<IActivityEdgeInstance> incomingEdges, List<IActivityNodeActivation> activations) {
        int j = 1;
        boolean notFound = true;
        while (j <= incomingEdges.size() & notFound) {
            int k = 1;
            while (k <= activations.size() & notFound) {
                if (activations.get(k - 1).isSourceFor(incomingEdges.get(j - 1)).booleanValue()) {
                    notFound = false;
                }
                ++k;
            }
            ++j;
        }
        return notFound;
    }

    public void runNodes(List<ActivityNode> nodes) {
        ArrayList<IActivityNodeActivation> nodeActivations = new ArrayList<IActivityNodeActivation>();
        int i = 0;
        while (i < nodes.size()) {
            ActivityNode node = nodes.get(i);
            IActivityNodeActivation nodeActivation = this.getNodeActivation(node);
            if (nodeActivation != null) {
                nodeActivations.add(nodeActivation);
            }
            ++i;
        }
        this.run(nodeActivations);
    }

    public void activate(List<ActivityNode> nodes, List<ActivityEdge> edges) {
        this.createNodeActivations(nodes);
        this.createEdgeInstances(edges);
        this.run(this.nodeActivations);
    }

    public void terminateAll() {
        List<IActivityNodeActivation> nodeActivations = this.nodeActivations;
        int i = 0;
        while (i < nodeActivations.size()) {
            IActivityNodeActivation nodeActivation = nodeActivations.get(i);
            nodeActivation.terminate();
            ++i;
        }
        this.suspendedActivations.clear();
    }

    public void createNodeActivations(List<ActivityNode> nodes) {
        int i = 0;
        while (i < nodes.size()) {
            ActivityNode node = nodes.get(i);
            Debug.println("[createNodeActivations] Creating a node activation for " + node.getName() + "...");
            this.createNodeActivation(node);
            ++i;
        }
    }

    public IActivityNodeActivation createNodeActivation(ActivityNode node) {
        IActivityNodeActivation activation = (IActivityNodeActivation)this.getActivityExecution().getLocus().getFactory().instantiateVisitor((Element)node);
        activation.initialize(node, (IActivityNodeActivationGroup)this);
        this.nodeActivations.add(activation);
        activation.createNodeActivations();
        return activation;
    }

    public IActivityNodeActivation getNodeActivation(ActivityNode node) {
        IPinActivation activation = null;
        if (this.containingNodeActivation != null && node instanceof Pin) {
            activation = this.containingNodeActivation.getPinActivation((Pin)node);
        }
        if (activation == null) {
            int i = 1;
            while (activation == null & i <= this.nodeActivations.size()) {
                activation = this.nodeActivations.get(i - 1).getNodeActivation(node);
                ++i;
            }
        }
        return activation;
    }

    public void createEdgeInstances(List<ActivityEdge> edges) {
        int i = 0;
        while (i < edges.size()) {
            ActivityEdge edge = edges.get(i);
            Debug.println("[createEdgeInstances] Creating an edge instance from " + edge.getSource().getName() + " to " + edge.getTarget().getName() + ".");
            IActivityEdgeInstance edgeInstance = (IActivityEdgeInstance)this.getActivityExecution().getLocus().getFactory().instantiateVisitor((Element)edge);
            edgeInstance.setEdge(edge);
            edgeInstance.setGroup((IActivityNodeActivationGroup)this);
            this.edgeInstances.add(edgeInstance);
            this.getNodeActivation(edge.getSource()).addOutgoingEdge(edgeInstance);
            this.getNodeActivation(edge.getTarget()).addIncomingEdge(edgeInstance);
            ++i;
        }
        List<IActivityNodeActivation> nodeActivations = this.nodeActivations;
        int i2 = 0;
        while (i2 < nodeActivations.size()) {
            IActivityNodeActivation nodeActivation = nodeActivations.get(i2);
            nodeActivation.createEdgeInstances();
            ++i2;
        }
    }

    public IActivityExecution getActivityExecution() {
        IActivityExecution activityExecution = this.activityExecution;
        if (activityExecution == null) {
            activityExecution = this.containingNodeActivation.getGroup().getActivityExecution();
        }
        return activityExecution;
    }

    public List<IActivityParameterNodeActivation> getOutputParameterNodeActivations() {
        ArrayList<IActivityParameterNodeActivation> parameterNodeActivations = new ArrayList<IActivityParameterNodeActivation>();
        List<IActivityNodeActivation> nodeActivations = this.nodeActivations;
        int i = 0;
        while (i < nodeActivations.size()) {
            IActivityNodeActivation activation = nodeActivations.get(i);
            if (activation instanceof IActivityParameterNodeActivation && activation.getIncomingEdges().size() > 0) {
                parameterNodeActivations.add((IActivityParameterNodeActivation)activation);
            }
            ++i;
        }
        return parameterNodeActivations;
    }

    public Boolean hasSourceFor(IActivityEdgeInstance edgeInstance) {
        boolean hasSource = false;
        List<IActivityNodeActivation> activations = this.nodeActivations;
        int i = 1;
        while (!hasSource & i <= activations.size()) {
            hasSource = activations.get(i - 1).isSourceFor(edgeInstance);
            ++i;
        }
        return hasSource;
    }

    public Boolean isSuspended() {
        if (this.suspendedActivations.size() > 0) {
            return true;
        }
        return false;
    }

    public void suspend(IActivityNodeActivation activation) {
        IStructuredActivityNodeActivation containingNodeActivation;
        Debug.println("[suspend] node=" + (activation.getNode() == null ? "null" : activation.getNode().getName()));
        if (!this.isSuspended().booleanValue() && (containingNodeActivation = this.containingNodeActivation) != null) {
            containingNodeActivation.suspend();
        }
        this.suspendedActivations.add(activation);
    }

    public void resume(IActivityNodeActivation activation) {
        IStructuredActivityNodeActivation containingNodeActivation;
        Debug.println("[resume] node=" + (activation.getNode() == null ? "null" : activation.getNode().getName()));
        boolean found = false;
        int i = 1;
        while (!found & i <= this.suspendedActivations.size()) {
            if (this.suspendedActivations.get(i - 1) == activation) {
                this.suspendedActivations.remove(i - 1);
                found = true;
            }
            ++i;
        }
        if (!this.isSuspended().booleanValue() && (containingNodeActivation = this.containingNodeActivation) != null) {
            containingNodeActivation.resume();
        }
    }

    public void setContainingActivation(IStructuredActivityNodeActivation activation) {
        this.containingNodeActivation = activation;
    }

    public IStructuredActivityNodeActivation getContainingActivation() {
        return this.containingNodeActivation;
    }

    public List<IActivityNodeActivation> getActivityNodeActivations() {
        return this.nodeActivations;
    }

    public void setActivityExecution_(IActivityExecution execution) {
        this.activityExecution = execution;
    }

    public IActivityExecution getActivityExecution_() {
        return this.activityExecution;
    }
}

