/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IOffer;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.activities.Offer;
import org.eclipse.uml2.uml.ActivityEdge;

public class ActivityEdgeInstance
implements IActivityEdgeInstance {
    public ActivityEdge edge;
    public IActivityNodeActivationGroup group;
    public IActivityNodeActivation source;
    public IActivityNodeActivation target;
    public List<IOffer> offers = new ArrayList<IOffer>();

    public void sendOffer(List<IToken> tokens) {
        Offer offer = new Offer();
        int i = 0;
        while (i < tokens.size()) {
            IToken token = tokens.get(i);
            offer.getTokens().add(token);
            ++i;
        }
        this.offers.add(offer);
        this.target.receiveOffer();
    }

    public Integer countOfferedValues() {
        int count = 0;
        List<IOffer> offers = this.offers;
        int i = 0;
        while (i < offers.size()) {
            count += offers.get(i).countOfferedValues().intValue();
            ++i;
        }
        return count;
    }

    public List<IToken> takeOfferedTokens() {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        while (this.offers.size() > 0) {
            List offeredTokens = this.offers.get(0).getOfferedTokens();
            int i = 0;
            while (i < offeredTokens.size()) {
                tokens.add((IToken)offeredTokens.get(i));
                ++i;
            }
            this.offers.remove(0);
        }
        return tokens;
    }

    public List<IToken> takeOfferedTokens(Integer maxCount) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        int remainingCount = maxCount;
        while (this.offers.size() > 0 & remainingCount > 0) {
            int i;
            IOffer offer = this.offers.get(0);
            List offeredTokens = offer.getOfferedTokens();
            int count = offer.countOfferedValues();
            if (count <= remainingCount) {
                i = 0;
                while (i < offeredTokens.size()) {
                    tokens.add((IToken)offeredTokens.get(i));
                    ++i;
                }
                remainingCount -= count;
                this.offers.remove(0);
                continue;
            }
            i = 0;
            while (i < remainingCount) {
                IToken token = (IToken)offeredTokens.get(i);
                if (token.getValue() != null) {
                    tokens.add(token);
                }
                ++i;
            }
            offer.removeOfferedValues(Integer.valueOf(remainingCount));
            remainingCount = 0;
        }
        return tokens;
    }

    public List<IToken> getOfferedTokens() {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        List<IOffer> offers = this.offers;
        int i = 0;
        while (i < offers.size()) {
            List offeredTokens = offers.get(i).getOfferedTokens();
            int j = 0;
            while (j < offeredTokens.size()) {
                tokens.add((IToken)offeredTokens.get(j));
                ++j;
            }
            ++i;
        }
        return tokens;
    }

    public Boolean hasOffer() {
        boolean hasTokens = false;
        int i = 1;
        while (!hasTokens & i <= this.offers.size()) {
            hasTokens = this.offers.get(i - 1).hasTokens();
            ++i;
        }
        return hasTokens;
    }

    public void setSource(IActivityNodeActivation source) {
        this.source = source;
    }

    public IActivityNodeActivation getSource() {
        return this.source;
    }

    public void setTarget(IActivityNodeActivation target) {
        this.target = target;
    }

    public IActivityNodeActivation getTarget() {
        return this.target;
    }

    public void setGroup(IActivityNodeActivationGroup group) {
        this.group = group;
    }

    public IActivityNodeActivationGroup getGroup() {
        return this.group;
    }

    public void setEdge(ActivityEdge edge) {
        this.edge = edge;
    }

    public ActivityEdge getEdge() {
        return this.edge;
    }

    public void _endIsolation() {
    }

    public void _beginIsolation() {
    }
}

