/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.actions.WriteLinkActionActivation;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.loci.ChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.ILink;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DestroyLinkAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.LinkEndData;
import org.eclipse.uml2.uml.LinkEndDestructionData;
import org.eclipse.uml2.uml.Property;

public class DestroyLinkActionActivation
extends WriteLinkActionActivation {
    @Override
    public void doAction() {
        Debug.println("[doAction] DestroyLinkAction...");
        DestroyLinkAction action = (DestroyLinkAction)this.node;
        ArrayList<LinkEndDestructionData> destructionDataList = new ArrayList<LinkEndDestructionData>();
        for (LinkEndData data : action.getEndData()) {
            destructionDataList.add((LinkEndDestructionData)data);
        }
        Debug.println("[doAction] end data size = " + destructionDataList.size());
        boolean destroyOnlyOne = false;
        int j = 1;
        while (!destroyOnlyOne & j <= destructionDataList.size()) {
            LinkEndDestructionData endData = (LinkEndDestructionData)destructionDataList.get(j - 1);
            destroyOnlyOne = !endData.getEnd().isUnique() & !endData.getEnd().isOrdered() & !endData.isDestroyDuplicates();
            ++j;
        }
        ArrayList<LinkEndData> endDataList = new ArrayList<LinkEndData>();
        int i = 0;
        while (i < destructionDataList.size()) {
            LinkEndDestructionData endData = (LinkEndDestructionData)destructionDataList.get(i);
            Debug.println("[doAction] Matching end = " + endData.getEnd().getName());
            endDataList.add((LinkEndData)endData);
            ++i;
        }
        List extent = this.getExecutionLocus().getExtent((Classifier)this.getAssociation());
        ArrayList<ILink> matchingLinks = new ArrayList<ILink>();
        int i2 = 0;
        while (i2 < extent.size()) {
            IExtensionalValue value = (IExtensionalValue)extent.get(i2);
            ILink link = (ILink)value;
            if (this.linkMatchesEndData(link, endDataList).booleanValue()) {
                matchingLinks.add(link);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < destructionDataList.size()) {
            LinkEndDestructionData endData = (LinkEndDestructionData)destructionDataList.get(i2);
            Property end = endData.getEnd();
            if (!endData.isDestroyDuplicates() & !end.isUnique() & end.isOrdered()) {
                InputPin inputPin = endData.getDestroyAt();
                DestroyLinkActionActivation destroyLinkActionActivation = this;
                try {
                    destroyLinkActionActivation.takeTokens(inputPin);
                }
                finally {
                    PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$2$e210d285(destroyLinkActionActivation, inputPin);
                }
            }
            Debug.println("[doAction] Consuming tokens for end " + end.getName());
            InputPin inputPin = endData.getValue();
            DestroyLinkActionActivation destroyLinkActionActivation = this;
            try {
                destroyLinkActionActivation.takeTokens(inputPin);
            }
            finally {
                PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$2$e210d285(destroyLinkActionActivation, inputPin);
            }
            ++i2;
        }
        if (destroyOnlyOne) {
            if (matchingLinks.size() > 0) {
                i2 = ((ChoiceStrategy)this.getExecutionLocus().getFactory().getStrategy("choice")).choose(matchingLinks.size());
                ((IExtensionalValue)matchingLinks.get(i2 - 1)).destroy();
            }
        } else {
            i2 = 0;
            while (i2 < matchingLinks.size()) {
                IExtensionalValue matchingLink = (IExtensionalValue)matchingLinks.get(i2);
                matchingLink.destroy();
                ++i2;
            }
        }
    }
}

