/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.actions.AcceptEventActionEventAccepter;
import org.eclipse.papyrus.moka.fuml.actions.ActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IAcceptEventActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IAcceptEventActionEventAccepter;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.commonbehavior.SignalEventOccurrence;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.ISignalInstance;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.OutputPin;

public class AcceptEventActionActivation
extends ActionActivation
implements IAcceptEventActionActivation {
    public IAcceptEventActionEventAccepter eventAccepter;
    public Boolean waiting;

    @Override
    public void run() {
        super.run();
        this.eventAccepter = new AcceptEventActionEventAccepter();
        this.eventAccepter.setAcceptEventActionActivation((IAcceptEventActionActivation)this);
        this.waiting = false;
    }

    @Override
    public void initialize(ActivityNode node, IActivityNodeActivationGroup group) {
        super.initialize(node, group);
        this.waiting = false;
    }

    @Override
    public void fire(List<IToken> incomingTokens) {
        Debug.println("[fire] Action " + this.node.getName() + "...");
        this.getExecutionContext().register((IEventAccepter)this.eventAccepter);
        this.waiting = true;
        this.firing = false;
        this.suspend();
    }

    @Override
    public Boolean isReady() {
        boolean ready = this.isWaiting() != false ? false : super.isReady();
        return ready;
    }

    public Boolean isWaiting() {
        return this.waiting == null ? false : this.waiting;
    }

    @Override
    public void doAction() {
    }

    public void accept(IEventOccurrence eventOccurrence) {
        block1: {
            block3: {
                EList resultPins;
                block2: {
                    AcceptEventAction action = (AcceptEventAction)this.node;
                    resultPins = action.getResults();
                    if (!this.running.booleanValue()) break block1;
                    if (action.isUnmarshall()) break block2;
                    if (!(eventOccurrence instanceof SignalEventOccurrence)) break block3;
                    ISignalInstance signalInstance = ((SignalEventOccurrence)eventOccurrence).signalInstance;
                    ArrayList<IValue> result = new ArrayList<IValue>();
                    result.add((IValue)signalInstance);
                    if (resultPins.size() <= 0) break block3;
                    this.putTokens((OutputPin)resultPins.get(0), result);
                    break block3;
                }
                List parameterValues = eventOccurrence.getParameterValues();
                int i = 0;
                while (i < parameterValues.size()) {
                    IParameterValue parameterValue = (IParameterValue)parameterValues.get(i);
                    OutputPin resultPin = (OutputPin)resultPins.get(i);
                    this.putTokens(resultPin, parameterValue.getValues());
                    ++i;
                }
            }
            this.sendOffers();
            this.waiting = false;
            this.receiveOffer();
            this.resume();
        }
    }

    public Boolean match(IEventOccurrence eventOccurrence) {
        AcceptEventAction action = (AcceptEventAction)this.node;
        return eventOccurrence.matchAny((List)action.getTriggers());
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.isWaiting().booleanValue()) {
            this.getExecutionContext().unregister((IEventAccepter)this.eventAccepter);
            this.waiting = false;
        }
    }

    public IAcceptEventActionEventAccepter getEventAccepter() {
        return this.eventAccepter;
    }
}

