/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.standardlibrary.library.io;

import java.io.OutputStream;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.library.ServiceObject;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.StringValue;
import org.eclipse.papyrus.moka.fuml.standardlibrary.library.io.FUMLIOConsole;
import org.eclipse.papyrus.moka.fuml.values.Value;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;

public final class StandardOutputChannelImpl
extends ServiceObject {
    protected OutputStream out = FUMLIOConsole.getInstance().getConsole().getOutputStream();
    private static final String WRITE_OPERATION = "write";
    private static final String WRITELINE_OPERATION = "writeLine";

    public StandardOutputChannelImpl(Class service) {
        super(service);
    }

    public IExecution dispatch(Operation operation) {
        ServiceObject.ServiceOperationExecution execution = null;
        if (operation != null) {
            if (operation.getName().equals(WRITE_OPERATION)) {
                execution = new Write(operation);
            } else if (operation.getName().equals(WRITELINE_OPERATION)) {
                execution = new WriteLine(operation);
            }
        }
        return execution;
    }

    protected class Write
    extends ServiceObject.ServiceOperationExecution {
        public Write(Operation operation) {
            super((ServiceObject)StandardOutputChannelImpl.this, operation);
        }

        public Value new_() {
            return new Write(this.operation);
        }

        public void doBody(List<IParameterValue> inputParameters, List<IParameterValue> outputParameters) {
            try {
                String message = ((IValue)inputParameters.get(0).getValues().get(0)).toString();
                StandardOutputChannelImpl.this.out.write(message.getBytes());
                StandardOutputChannelImpl.this.out.flush();
            }
            catch (Exception e) {
                Debug.println((String)("An error occured during the execution of write " + e.getMessage()));
            }
        }
    }

    protected class WriteLine
    extends ServiceObject.ServiceOperationExecution {
        public WriteLine(Operation operation) {
            super((ServiceObject)StandardOutputChannelImpl.this, operation);
        }

        public Value new_() {
            return new WriteLine(this.operation);
        }

        public void doBody(List<IParameterValue> inputParameters, List<IParameterValue> outputParameters) {
            try {
                String message = "";
                message = ((StringValue)inputParameters.get((int)0).getValues().get((int)0)).value;
                StandardOutputChannelImpl.this.out.write((String.valueOf(message) + "\n").getBytes());
                StandardOutputChannelImpl.this.out.flush();
            }
            catch (Exception e) {
                Debug.println((String)("An error occured during the execution of writeLine " + e.getMessage()));
            }
        }
    }
}

