/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml;

import java.util.ArrayList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.engine.uml.AbstractUMLExecutionEngine;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLRootTaskExecution;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineException;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IScheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.control.Scheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecution;
import org.eclipse.uml2.uml.Element;

public class UMLExecutionEngine
extends AbstractUMLExecutionEngine {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(SubMonitor monitor) throws ExecutionEngineException {
        EObject executionSource = this.configuration.getExecutionSource();
        if (!(executionSource instanceof Element)) throw new IllegalArgumentException("ExecutionSource in configuration must be instanceOf UML::Element");
        Element source = (Element)this.configuration.getExecutionSource();
        if (this.locus == null || source == null) return;
        IUMLRootTaskExecution rootExecution = this.rootTaskFactory.createRootExecution(source);
        if (rootExecution == null) throw new ExecutionEngineException(this.identifier, this.status, "Could not instantiate an execution from the specified element");
        rootExecution.setLocus(this.locus);
        rootExecution.setInputParameterValues(new ArrayList());
        if (!rootExecution.canExecute()) throw new ExecutionEngineException(this.identifier, this.status, "Could not start the execution from the specified model element");
        this.controller.getExecutionLoop().init((ITaskExecution)rootExecution, (IScheduler)new Scheduler());
        SubMonitor progress = monitor.split(1);
        progress.subTask("Run model");
        this.controller.start();
        progress.worked(1);
    }
}

