/**
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   IBM - Initial API and implementation
 */
package ordersystem;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Line
 * Item</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link ordersystem.LineItem#getQuantity <em>Quantity</em>}</li>
 * <li>{@link ordersystem.LineItem#getDiscount <em>Discount</em>}</li>
 * <li>{@link ordersystem.LineItem#getOwner <em>Owner</em>}</li>
 * <li>{@link ordersystem.LineItem#getProduct <em>Product</em>}</li>
 * </ul>
 * </p>
 *
 * @see ordersystem.OrderSystemPackage#getLineItem()
 * @model
 * @generated
 */
public interface LineItem extends EObject {
	/**
	 * Returns the value of the '<em><b>Quantity</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Quantity</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Quantity</em>' attribute.
	 * @see #setQuantity(int)
	 * @see ordersystem.OrderSystemPackage#getLineItem_Quantity()
	 * @model
	 * @generated
	 */
	int getQuantity();

	/**
	 * Sets the value of the '{@link ordersystem.LineItem#getQuantity
	 * <em>Quantity</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value the new value of the '<em>Quantity</em>' attribute.
	 * @see #getQuantity()
	 * @generated
	 */
	void setQuantity(int value);

	/**
	 * Returns the value of the '<em><b>Discount</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Discount</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Discount</em>' attribute.
	 * @see #setDiscount(double)
	 * @see ordersystem.OrderSystemPackage#getLineItem_Discount()
	 * @model
	 * @generated
	 */
	double getDiscount();

	/**
	 * Sets the value of the '{@link ordersystem.LineItem#getDiscount
	 * <em>Discount</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value the new value of the '<em>Discount</em>' attribute.
	 * @see #getDiscount()
	 * @generated
	 */
	void setDiscount(double value);

	/**
	 * Returns the value of the '<em><b>Owner</b></em>' container reference. It is
	 * bidirectional and its opposite is '{@link ordersystem.Order#getItem
	 * <em>Item</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owner</em>' container reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Owner</em>' container reference.
	 * @see #setOwner(Order)
	 * @see ordersystem.OrderSystemPackage#getLineItem_Owner()
	 * @see ordersystem.Order#getItem
	 * @model opposite="item"
	 * @generated
	 */
	Order getOwner();

	/**
	 * Sets the value of the '{@link ordersystem.LineItem#getOwner <em>Owner</em>}'
	 * container reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value the new value of the '<em>Owner</em>' container reference.
	 * @see #getOwner()
	 * @generated
	 */
	void setOwner(Order value);

	/**
	 * Returns the value of the '<em><b>Product</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Product</em>' reference isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Product</em>' reference.
	 * @see #setProduct(Product)
	 * @see ordersystem.OrderSystemPackage#getLineItem_Product()
	 * @model required="true"
	 * @generated
	 */
	Product getProduct();

	/**
	 * Sets the value of the '{@link ordersystem.LineItem#getProduct
	 * <em>Product</em>}' reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value the new value of the '<em>Product</em>' reference.
	 * @see #getProduct()
	 * @generated
	 */
	void setProduct(Product value);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @model kind="operation"
	 * @generated
	 */
	double getCost();

} // LineItem
