/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public abstract class Worker
extends Lifecycle {
    public static final int DEFAULT_TIMEOUT = 10000;
    private boolean daemon;
    private long activationTimeout = 10000L;
    private long deactivationTimeout = 10000L;
    @ReflectUtil.ExcludeFromDump
    private transient CountDownLatch activationLatch;
    @ReflectUtil.ExcludeFromDump
    private transient WorkerThread workerThread;

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public long getActivationTimeout() {
        return this.activationTimeout;
    }

    public void setActivationTimeout(long activationTimeout) {
        this.activationTimeout = activationTimeout;
    }

    public long getDeactivationTimeout() {
        return this.deactivationTimeout;
    }

    public void setDeactivationTimeout(long deactivationTimeout) {
        this.deactivationTimeout = deactivationTimeout;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.activationLatch = new CountDownLatch(1);
        String threadName = this.getThreadName();
        this.workerThread = threadName == null ? new WorkerThread() : new WorkerThread(threadName);
        this.workerThread.start();
        if (!this.activationLatch.await(this.activationTimeout, TimeUnit.MILLISECONDS)) {
            try {
                this.workerThread.stopRunning();
                this.workerThread.interrupt();
            }
            catch (RuntimeException runtimeException) {}
            throw new TimeoutException("Worker thread activation timed out after " + this.activationTimeout + " millis");
        }
    }

    protected void doDeactivate() throws Exception {
        try {
            this.workerThread.stopRunning();
            this.workerThread.interrupt();
            this.workerThread.join(this.deactivationTimeout);
        }
        catch (RuntimeException runtimeException) {}
        super.doDeactivate();
    }

    protected String getThreadName() {
        return null;
    }

    protected abstract void work(WorkContext var1) throws Exception;

    private static final class NextWork
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private long pauseMillis;

        public NextWork() {
        }

        public NextWork(long pauseMillis) {
            this.pauseMillis = pauseMillis;
        }

        public void pause() throws InterruptedException {
            if (this.pauseMillis > 0L) {
                Thread.sleep(this.pauseMillis);
            }
        }
    }

    private static final class Terminate
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public final class WorkContext {
        private long count;

        public long getCount() {
            return this.count;
        }

        public void nextWork() {
            throw new NextWork();
        }

        public void nextWork(long pauseMillis) {
            throw new NextWork(pauseMillis);
        }

        public void terminate() {
            throw new Terminate();
        }

        private void increaseCount() {
            ++this.count;
        }
    }

    private final class WorkerThread
    extends Thread {
        private boolean running;

        public WorkerThread() {
            this.running = true;
            this.setDaemon(Worker.this.daemon);
        }

        public WorkerThread(String threadName) {
            super(threadName);
            this.running = true;
            this.setDaemon(Worker.this.daemon);
        }

        public void stopRunning() {
            this.running = false;
        }

        public void run() {
            WorkContext context = new WorkContext();
            Worker.this.activationLatch.countDown();
            while (this.running && !this.isInterrupted()) {
                try {
                    context.increaseCount();
                    Worker.this.work(context);
                }
                catch (NextWork nextWork) {
                    try {
                        nextWork.pause();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                catch (Terminate terminate) {
                    break;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Exception ex) {
                    OM.LOG.error(ex);
                    break;
                }
            }
            Worker.this.deactivate();
        }
    }
}

