/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.eclipse.net4j.util.concurrent.IWorkSerializer;
import org.eclipse.net4j.util.concurrent.OnePendingExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionWorkSerializer
implements IWorkSerializer {
    private CompletionService<Object> completionService;

    public CompletionWorkSerializer(CompletionService<Object> completionService) {
        this.completionService = completionService;
    }

    public CompletionWorkSerializer(Executor executor, BlockingQueue<Future<Object>> completionQueue) {
        this(new ExecutorCompletionService<Object>(executor, completionQueue));
    }

    public CompletionWorkSerializer(Executor executor) {
        this(new ExecutorCompletionService<Object>(executor));
    }

    public CompletionWorkSerializer() {
        this(new OnePendingExecutor());
    }

    public CompletionService<Object> getCompletionService() {
        return this.completionService;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean addWork(Runnable work) {
        this.completionService.submit(work, true);
        return true;
    }

    public String toString() {
        return CompletionWorkSerializer.class.getSimpleName();
    }
}

