/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.sample.epo2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OrderStatus implements Enumerator
{
    PENDING_LITERAL(0, "Pending", "Pending"),
    BACK_ORDER_LITERAL(1, "BackOrder", "BackOrder"),
    COMPLETE_LITERAL(2, "Complete", "Complete");

    public static final int PENDING = 0;
    public static final int BACK_ORDER = 1;
    public static final int COMPLETE = 2;
    private static final OrderStatus[] VALUES_ARRAY;
    public static final List<OrderStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OrderStatus[]{PENDING_LITERAL, BACK_ORDER_LITERAL, COMPLETE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OrderStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrderStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrderStatus get(int value) {
        switch (value) {
            case 0: {
                return PENDING_LITERAL;
            }
            case 1: {
                return BACK_ORDER_LITERAL;
            }
            case 2: {
                return COMPLETE_LITERAL;
            }
        }
        return null;
    }

    private OrderStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

