/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink;

import java.lang.reflect.Field;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.teneo.eclipselink.EmfCollectionAdjuster;
import org.eclipse.emf.teneo.eclipselink.EmfInstanceVariableAccessor;
import org.eclipse.emf.teneo.eclipselink.EmfSessionEventListener;
import org.eclipse.emf.teneo.eclipselink.EmfTransparentIndirectionPolicy;
import org.eclipse.emf.teneo.eclipselink.elist.EListContainerPolicy;
import org.eclipse.emf.teneo.eclipselink.elist.EclipseLinkEList;
import org.eclipse.emf.teneo.eclipselink.elist.IndirectEList;
import org.eclipse.emf.teneo.eclipselink.emap.EclipseLinkEMap;
import org.eclipse.emf.teneo.eclipselink.emap.IndirectEMap;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;

public class EmfSessionCustomizer
implements SessionCustomizer {
    protected static EmfCollectionAdjuster collectionAdjuster = new EmfCollectionAdjuster();

    public void customize(Session session) throws EclipseLinkException {
        session.getEventManager().addListener((SessionEventListener)new EmfSessionEventListener());
        for (ClassDescriptor descriptor : session.getDescriptors().values()) {
            if (!Helper.classImplementsInterface((Class)descriptor.getJavaClass(), EObject.class)) continue;
            boolean shouldAttachListener = false;
            for (Object element : descriptor.getMappings()) {
                DatabaseMapping dbMapping = (DatabaseMapping)element;
                this.enhanceAttributeAccesssor(dbMapping);
                if (!dbMapping.isCollectionMapping()) continue;
                CollectionMapping collectionMapping = (CollectionMapping)dbMapping;
                this.adjustListMapping(collectionMapping);
                shouldAttachListener = true;
            }
            if (!shouldAttachListener) continue;
            descriptor.getEventManager().addListener((DescriptorEventListener)collectionAdjuster);
        }
    }

    private boolean isMapCollection(CollectionMapping collectionMapping) throws EclipseLinkException {
        boolean result = false;
        try {
            String attributeName = collectionMapping.getAttributeName();
            Class mappedClass = collectionMapping.getDescriptor().getJavaClass();
            Field collectionField = Helper.getField((Class)mappedClass, (String)attributeName);
            result = Helper.classImplementsInterface(collectionField.getType(), EMap.class);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw DescriptorException.noFieldNameForMapping((DatabaseMapping)collectionMapping);
        }
        return result;
    }

    private void adjustListMapping(CollectionMapping collectionMapping) throws EclipseLinkException {
        EListContainerPolicy newContainerPolicy = new EListContainerPolicy(collectionMapping.getAttributeName());
        collectionMapping.setContainerPolicy((ContainerPolicy)newContainerPolicy);
        ReadAllQuery selectionQuery = (ReadAllQuery)collectionMapping.getSelectionQuery();
        selectionQuery.setContainerPolicy((ContainerPolicy)newContainerPolicy);
        if (collectionMapping.usesIndirection()) {
            collectionMapping.setIndirectionPolicy((IndirectionPolicy)new EmfTransparentIndirectionPolicy());
            if (this.isMapCollection(collectionMapping)) {
                newContainerPolicy.setContainerClass(IndirectEMap.class);
            } else {
                newContainerPolicy.setContainerClass(IndirectEList.class);
            }
        } else {
            collectionMapping.setIndirectionPolicy((IndirectionPolicy)new NoIndirectionPolicy());
            if (this.isMapCollection(collectionMapping)) {
                newContainerPolicy.setContainerClass(EclipseLinkEMap.class);
            } else {
                newContainerPolicy.setContainerClass(EclipseLinkEList.class);
            }
        }
    }

    private void enhanceAttributeAccesssor(DatabaseMapping dbMapping) {
        EmfInstanceVariableAccessor.customize(dbMapping);
    }
}

