/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.analyzer.CDOFetchRule;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.internal.cdo.analyzer.CDOFetchFeatureInfo;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAnalyzerFeatureInfo {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOAnalyzerFeatureInfo.class);
    private Map<CDOFetchFeatureInfo, CDOFetchFeatureInfo> featureStats = new HashMap<CDOFetchFeatureInfo, CDOFetchFeatureInfo>();
    private Map<CDOClass, CDOFetchRule> fetchRules = new HashMap<CDOClass, CDOFetchRule>();

    public Collection<CDOFetchRule> getRules(CDOClass cdoClass, CDOFeature cdoFeature) {
        return this.fetchRules.values();
    }

    public synchronized CDOFetchFeatureInfo getFeatureStat(CDOClass cdoClass, CDOFeature cdoFeature) {
        CDOFetchFeatureInfo search = new CDOFetchFeatureInfo(cdoClass, cdoFeature);
        CDOFetchFeatureInfo featureRule = this.featureStats.get(search);
        if (featureRule == null) {
            featureRule = search;
            this.featureStats.put(search, featureRule);
        }
        return featureRule;
    }

    public boolean isActive(CDOClass cdoClass, CDOFeature cdoFeature) {
        CDOFetchFeatureInfo search = new CDOFetchFeatureInfo(cdoClass, cdoFeature);
        CDOFetchFeatureInfo featureRule = this.featureStats.get(search);
        return featureRule != null && featureRule.isActive();
    }

    public void activate(CDOClass cdoClass, CDOFeature cdoFeature) {
        CDOFetchFeatureInfo info = this.getFeatureStat(cdoClass, cdoFeature);
        if (!info.isActive()) {
            info.setActive(true);
            this.addRule(cdoClass, cdoFeature);
        }
    }

    public void deactivate(CDOClass cdoClass, CDOFeature cdoFeature) {
        CDOFetchFeatureInfo info = this.getFeatureStat(cdoClass, cdoFeature);
        if (info.isActive()) {
            info.setActive(false);
            this.removeRule(cdoClass, cdoFeature);
        }
    }

    private void addRule(CDOClass cdoClass, CDOFeature cdoFeature) {
        CDOFetchRule fetchRule;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding rule : {0}.{1}", new Object[]{cdoClass.getName(), cdoFeature.getName()});
        }
        if ((fetchRule = this.fetchRules.get(cdoClass)) == null) {
            fetchRule = new CDOFetchRule(cdoClass);
            this.fetchRules.put(cdoClass, fetchRule);
        }
        fetchRule.addFeature(cdoFeature);
    }

    private void removeRule(CDOClass cdoClass, CDOFeature cdoFeature) {
        CDOFetchRule fetchRule;
        if (TRACER.isEnabled()) {
            TRACER.format("Removing rule : {0}.{1}", new Object[]{cdoClass.getName(), cdoFeature.getName()});
        }
        if ((fetchRule = this.fetchRules.get(cdoClass)) == null) {
            return;
        }
        fetchRule.removeFeature(cdoFeature);
    }
}

