/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.CDOTransaction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RollbackTransactionDialog
extends TitleAreaDialog {
    public static final int REMOTE = 2;
    public static final int LOCAL = 3;
    private static final int REMOTE_ID = 1026;
    private static final int LOCAL_ID = 1027;
    private IWorkbenchPage page;
    private String title;
    private String description;
    private CDOTransaction transaction;

    public RollbackTransactionDialog(IWorkbenchPage page, String title, String description, CDOTransaction transaction) {
        super(new Shell(page.getWorkbenchWindow().getShell()));
        this.page = page;
        this.title = title;
        this.description = description;
        this.transaction = transaction;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout(1, false));
        this.setTitle(this.description);
        this.setTitleImage(this.getShell().getDisplay().getSystemImage(4));
        Label label = new Label(composite, 0);
        label.setText(this.formatMessage());
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1026, "Remote Rollback", true);
        this.createButton(parent, 1027, "Local Rollback", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1026) {
            this.setReturnCode(2);
            this.close();
        } else if (buttonId == 1027) {
            this.setReturnCode(3);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected String formatMessage() {
        int newObjects = this.transaction.getNewObjects().size();
        int dirtyObjects = this.transaction.getDirtyObjects().size();
        int count = (newObjects > 0 ? 1 : 0) + (dirtyObjects > 0 ? 1 : 0);
        StringBuilder builder = new StringBuilder();
        builder.append("This transaction contains ");
        if (newObjects > 0) {
            builder.append(newObjects);
            builder.append(" new object");
            if (newObjects > 1) {
                builder.append("s");
            }
        }
        if (dirtyObjects > 0) {
            if (count > 0) {
                builder.append(" and ");
            }
            builder.append(dirtyObjects);
            builder.append(" dirty object");
            if (dirtyObjects > 1) {
                builder.append("s");
            }
        }
        builder.append(".\n\nBe careful, rolling back to local state can result\nin visible state that is different from the remote state!");
        builder.append("\n\nAre you sure to rollback this transaction?");
        return builder.toString();
    }
}

