/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class StoreAccessor
extends Lifecycle
implements IStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, StoreAccessor.class);
    private List<IStoreAccessor.CommitContext> commitContexts = new ArrayList<IStoreAccessor.CommitContext>();
    private Store store;
    private Object context;
    private boolean reader;

    private StoreAccessor(Store store, Object context, boolean reader) {
        this.store = store;
        this.context = context;
        this.reader = reader;
    }

    protected StoreAccessor(Store store, ISession session) {
        this(store, session, true);
    }

    protected StoreAccessor(Store store, ITransaction transaction) {
        this(store, transaction, false);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isReader() {
        return this.reader;
    }

    public ISession getSession() {
        if (this.context instanceof ITransaction) {
            return ((ITransaction)this.context).getSession();
        }
        return (ISession)this.context;
    }

    public ITransaction getTransaction() {
        if (this.context instanceof ITransaction) {
            return (ITransaction)this.context;
        }
        return null;
    }

    public CDOID readResourceID(CDOID folderID, String name, long timeStamp) {
        IStoreAccessor.QueryResourcesContext.ExactMatch context = Store.createExactMatchContext(folderID, name, timeStamp);
        this.queryResources(context);
        return context.getResourceID();
    }

    public InternalCDORevision verifyRevision(InternalCDORevision revision) {
        return revision;
    }

    public void write(IStoreAccessor.CommitContext context, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing transaction: {0}", new Object[]{this.getTransaction()});
        }
        this.commitContexts.add(context);
        long timeStamp = context.getTimeStamp();
        boolean deltas = this.store.getRepository().isSupportingRevisionDeltas();
        InternalCDOPackageUnit[] newPackageUnits = context.getNewPackageUnits();
        InternalCDORevision[] newObjects = context.getNewObjects();
        CDOID[] detachedObjects = context.getDetachedObjects();
        int dirtyCount = deltas ? context.getDirtyObjectDeltas().length : context.getDirtyObjects().length;
        try {
            monitor.begin((double)(newPackageUnits.length + 2 + newObjects.length + detachedObjects.length + dirtyCount));
            if (newPackageUnits.length != 0) {
                this.writePackageUnits(newPackageUnits, monitor.fork((double)newPackageUnits.length));
            }
            this.addIDMappings(context, monitor.fork());
            context.applyIDMappings(monitor.fork());
            if (detachedObjects.length != 0) {
                this.detachObjects(detachedObjects, timeStamp - 1L, monitor.fork((double)detachedObjects.length));
            }
            if (newObjects.length != 0) {
                this.writeRevisions(newObjects, monitor.fork((double)newObjects.length));
            }
            if (dirtyCount != 0) {
                if (deltas) {
                    this.writeRevisionDeltas(context.getDirtyObjectDeltas(), timeStamp, monitor.fork((double)dirtyCount));
                } else {
                    this.writeRevisions(context.getDirtyObjects(), monitor.fork((double)dirtyCount));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void rollback() {
        if (TRACER.isEnabled()) {
            TRACER.format("Rolling back transaction: {0}", new Object[]{this.getTransaction()});
        }
        for (IStoreAccessor.CommitContext commitContext : this.commitContexts) {
            this.rollback(commitContext);
        }
    }

    protected abstract void rollback(IStoreAccessor.CommitContext var1);

    public final void release() {
        this.store.releaseAccessor(this);
        this.commitContexts.clear();
    }

    protected abstract void addIDMappings(IStoreAccessor.CommitContext var1, OMMonitor var2);

    protected abstract void writeRevisions(InternalCDORevision[] var1, OMMonitor var2);

    protected abstract void writeRevisionDeltas(InternalCDORevisionDelta[] var1, long var2, OMMonitor var4);

    protected abstract void detachObjects(CDOID[] var1, long var2, OMMonitor var4);

    protected abstract void doActivate() throws Exception;

    protected abstract void doDeactivate() throws Exception;

    protected abstract void doPassivate() throws Exception;

    protected abstract void doUnpassivate() throws Exception;
}

