/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.AbstractPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;

public class NullPreparedStatementCache
extends AbstractPreparedStatementCache {
    private HashSet<PreparedStatement> allocatedStatements = new HashSet();

    public PreparedStatement getPreparedStatement(String sql, IPreparedStatementCache.ReuseProbability reuseProbability) {
        try {
            PreparedStatement result = this.getConnection().prepareStatement(sql);
            this.allocatedStatements.add(result);
            return result;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void releasePreparedStatement(PreparedStatement ps) {
        this.allocatedStatements.remove(ps);
        DBUtil.close((Statement)ps);
    }

    protected void doBeforeDeactivate() throws Exception {
        if (!this.allocatedStatements.isEmpty()) {
            OM.LOG.warn("Possible Leak Detected:");
            for (PreparedStatement ps : this.allocatedStatements) {
                OM.LOG.warn("- " + ps.toString());
            }
            assert (false);
        }
    }
}

