/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.fixtures.TestListener;

public class BasicTransactionTest
extends AbstractTest {
    public BasicTransactionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(BasicTransactionTest.class, "Basic Transaction Tests");
    }

    public void test_read() {
        try {
            BasicTransactionTest.assertNotNull((Object)this.find("root/Root Book"));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_read_readOnlyTransaction() {
        this.startReading();
        BasicTransactionTest.assertNotNull((Object)this.find("root/Root Book"));
        this.commit();
    }

    public void test_read_readWriteTransaction() {
        this.startWriting();
        BasicTransactionTest.assertNotNull((Object)this.find("root/Root Book"));
        this.commit();
    }

    public void test_read_exclusive() {
        try {
            final Book[] book = new Book[1];
            this.domain.runExclusive(new Runnable(){

                public void run() {
                    book[0] = (Book)BasicTransactionTest.this.find("root/Root Book");
                }
            });
            BasicTransactionTest.assertNotNull((Object)book[0]);
        }
        catch (InterruptedException e) {
            BasicTransactionTest.fail((String)"Should not be interrupted");
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_read_exclusive_nested() {
        try {
            this.domain.runExclusive(new Runnable(){

                public void run() {
                    try {
                        BasicTransactionTest.this.domain.runExclusive(new Runnable(){

                            public void run() {
                                try {
                                    (this).BasicTransactionTest.this.domain.runExclusive(new Runnable(){

                                        public void run() {
                                            InternalTransaction active = ((InternalTransactionalEditingDomain)((this).this).BasicTransactionTest.this.domain).getActiveTransaction();
                                            BasicTransactionTest.assertNotNull((Object)active);
                                            BasicTransactionTest.assertTrue((boolean)active.isReadOnly());
                                            BasicTransactionTest.assertNull((Object)active.getParent());
                                        }
                                    });
                                }
                                catch (InterruptedException e) {
                                    BasicTransactionTest.fail((String)"Should not be interrupted");
                                }
                                catch (Exception e) {
                                    BasicTransactionTest.this.fail(e);
                                }
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        BasicTransactionTest.fail((String)"Should not be interrupted");
                    }
                    catch (Exception e) {
                        BasicTransactionTest.this.fail(e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            BasicTransactionTest.fail((String)"Should not be interrupted");
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_write() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        this.commit();
        try {
            book.setTitle("New Title");
            BasicTransactionTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_write_readOnlytransaction() {
        try {
            try {
                this.startReading();
                Book book = (Book)this.find("root/Root Book");
                book.setTitle("New Title");
                BasicTransactionTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
                this.rollback();
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_write_readWritetransaction() {
        try {
            try {
                this.startWriting();
                Book book = (Book)this.find("root/Root Book");
                book.setTitle("New Title");
                this.commit();
                BasicTransactionTest.assertEquals((String)"New Title", (String)book.getTitle());
            }
            catch (Exception e) {
                this.fail(e);
                if (this.getActiveTransaction() != null) {
                    this.rollback();
                }
            }
        }
        finally {
            if (this.getActiveTransaction() != null) {
                this.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_write_wrongThread() {
        block21: {
            final Object monitor = new Object();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    InternalTransaction xa = null;
                    try {
                        try {
                            Object object = monitor;
                            synchronized (object) {
                                block15: {
                                    xa = ((InternalTransactionalEditingDomain)BasicTransactionTest.this.domain).startTransaction(true, null);
                                    monitor.notifyAll();
                                    monitor.wait();
                                    try {
                                        try {
                                            xa.commit();
                                            BasicTransactionTest.fail((String)"Should have thrown RollbackException");
                                        }
                                        catch (RollbackException e) {
                                            BasicTransactionTest.trace("Got expected rollback: " + e.getLocalizedMessage());
                                            xa = null;
                                            break block15;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        xa = null;
                                        throw throwable;
                                    }
                                    xa = null;
                                }
                            }
                        }
                        catch (Exception e) {
                            BasicTransactionTest.this.fail(e);
                            if (xa != null) {
                                xa.rollback();
                            }
                        }
                    }
                    finally {
                        if (xa != null) {
                            xa.rollback();
                        }
                    }
                }
            });
            try {
                Object object = monitor;
                synchronized (object) {
                    t.start();
                    monitor.wait();
                }
                Book book = (Book)this.find("root/Root Book");
                book.setTitle("New Title");
                BasicTransactionTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
                Object object = monitor;
                synchronized (object) {
                    monitor.notifyAll();
                    break block21;
                }
            }
            catch (Exception e) {
                Object object;
                try {
                    this.fail(e);
                    object = monitor;
                }
                catch (Throwable throwable) {
                    Object object2 = monitor;
                    synchronized (object2) {
                        monitor.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (object) {
                    monitor.notifyAll();
                    break block21;
                }
            }
            Object object = monitor;
            synchronized (object) {
                monitor.notifyAll();
            }
        }
    }

    public void test_write_command() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        this.commit();
        try {
            SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)"New Title");
            ((TransactionalCommandStack)this.domain.getCommandStack()).execute((Command)cmd, null);
            this.startReading();
            BasicTransactionTest.assertEquals((String)"New Title", (String)book.getTitle());
            this.commit();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_loadUnloadDuringRead() throws Exception {
        this.doTearDown();
        ResourceSetImpl rset = new ResourceSetImpl();
        this.domain = this.createEditingDomain((ResourceSet)rset);
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startReading();
        Resource res = rset.createResource(URI.createURI((String)EmfTransactionTestsBundle.getEntry("/test_models/test_model.extlibrary").toString()));
        res.load(Collections.EMPTY_MAP);
        this.commit();
        BasicTransactionTest.assertNotNull((Object)listener.postcommit);
        List<Notification> notifications = listener.postcommitNotifications;
        BasicTransactionTest.assertFalse((boolean)notifications.isEmpty());
        Notification rootAdded = null;
        Notification resLoaded = null;
        for (Notification next : notifications) {
            if (next.getNotifier() != res) continue;
            if (next.getFeatureID(null) == 4) {
                if (!next.getNewBooleanValue()) continue;
                BasicTransactionTest.assertNotNull(rootAdded);
                resLoaded = next;
                continue;
            }
            if (next.getFeatureID(null) != 2 || next.getEventType() != 3) continue;
            rootAdded = next;
        }
        BasicTransactionTest.assertNotNull(rootAdded);
        BasicTransactionTest.assertNotNull(resLoaded);
        listener.reset();
        this.startReading();
        res.unload();
        this.commit();
        BasicTransactionTest.assertNotNull((Object)listener.postcommit);
        notifications = listener.postcommitNotifications;
        BasicTransactionTest.assertFalse((boolean)notifications.isEmpty());
        Notification rootRemoved = null;
        Notification resUnloaded = null;
        for (Notification next : notifications) {
            if (next.getNotifier() != res) continue;
            if (next.getFeatureID(null) == 4) {
                if (next.getNewBooleanValue()) continue;
                BasicTransactionTest.assertNotNull(rootRemoved);
                resUnloaded = next;
                continue;
            }
            if (next.getFeatureID(null) != 2 || next.getEventType() != 4) continue;
            rootRemoved = next;
        }
        BasicTransactionTest.assertNotNull(rootRemoved);
        BasicTransactionTest.assertNotNull(resUnloaded);
    }

    public void test_resourceContentsChanges_read() {
        try {
            try {
                this.startReading();
                this.testResource.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                BasicTransactionTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
                this.rollback();
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_resourceContentsChanges_write() {
        try {
            try {
                this.startWriting();
                this.testResource.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_newResourceContentsChanges_read() {
        try {
            try {
                this.startReading();
                Resource res = this.domain.getResourceSet().createResource(URI.createFileURI((String)"/tmp/foo.extlibrary"));
                BasicTransactionTest.assertFalse((boolean)res.isLoaded());
                res.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                BasicTransactionTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
                this.rollback();
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_newResourceContentsChanges_write() {
        try {
            try {
                this.startWriting();
                Resource res = this.domain.getResourceSet().createResource(URI.createFileURI((String)"/tmp/foo.extlibrary"));
                BasicTransactionTest.assertFalse((boolean)res.isLoaded());
                res.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_concurrentWrite_runnable() {
        final Object monitor = new Object();
        final Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = monitor;
                synchronized (object) {
                    block8: {
                        try {
                            try {
                                BasicTransactionTest.this.testResource.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                            }
                            catch (IllegalStateException e) {
                                BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
                                monitor.notify();
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.notify();
                            throw throwable;
                        }
                        monitor.notify();
                    }
                }
            }
        });
        try {
            RunnableWithResult.Impl<Object> rwr = new RunnableWithResult.Impl<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = monitor;
                    synchronized (object) {
                        t.start();
                        try {
                            monitor.wait();
                        }
                        catch (InterruptedException e) {
                            BasicTransactionTest.this.fail(e);
                        }
                    }
                }
            };
            this.domain.runExclusive((Runnable)rwr);
            BasicTransactionTest.assertNotNull((Object)rwr.getStatus());
            BasicTransactionTest.assertEquals((int)4, (int)rwr.getStatus().getSeverity());
            BasicTransactionTest.assertEquals((int)40, (int)rwr.getStatus().getCode());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_closedTransaction_close() {
        this.startReading();
        Transaction tx = this.commit();
        try {
            tx.commit();
            BasicTransactionTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (RollbackException e) {
            this.fail((Exception)((Object)e));
        }
        try {
            tx.rollback();
            BasicTransactionTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            BasicTransactionTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_readWrongThread_250498() {
        block17: {
            final Object monitor = new Object();
            final ArrayList readNotifications = new ArrayList();
            ResourceSetListenerImpl l = new ResourceSetListenerImpl(){

                public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                    Command result = null;
                    for (Notification next : event.getNotifications()) {
                        if (!(next.getNotifier() instanceof Book) || next.getFeature() != EXTLibraryPackage.Literals.BOOK__TITLE) continue;
                        Command cmd = BasicTransactionTest.this.domain.createCommand(SetCommand.class, new CommandParameter(next.getNotifier(), next.getFeature(), (Object)123));
                        Command command = result = result == null ? cmd : result.chain(cmd);
                    }
                    return result;
                }

                public void resourceSetChanged(ResourceSetChangeEvent event) {
                    for (Notification next : event.getNotifications()) {
                        if (!NotificationFilter.READ.matches(next)) continue;
                        readNotifications.add(next);
                    }
                }
            };
            this.domain.addResourceSetListener((ResourceSetListener)l);
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block42: {
                        InternalTransaction xa = null;
                        try {
                            try {
                                Object object = monitor;
                                synchronized (object) {
                                    block40: {
                                        xa = ((InternalTransactionalEditingDomain)BasicTransactionTest.this.domain).startTransaction(false, null);
                                        TreeIterator all = BasicTransactionTest.this.root.eAllContents();
                                        while (all.hasNext()) {
                                            Object next = all.next();
                                            if (!(next instanceof Book)) continue;
                                            Book book = (Book)next;
                                            book.setTitle("123 " + book.getTitle());
                                            Library lib = (Library)book.eContainer();
                                            if (lib.getWriters().isEmpty()) continue;
                                            book.setAuthor((Writer)lib.getWriters().get(0));
                                        }
                                        monitor.notifyAll();
                                        monitor.wait();
                                        try {
                                            try {
                                                xa.commit();
                                            }
                                            catch (RollbackException e) {
                                                BasicTransactionTest.fail((String)("Should not have rolled back: " + e.getLocalizedMessage()));
                                                xa = null;
                                                break block40;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            xa = null;
                                            throw throwable;
                                        }
                                        xa = null;
                                    }
                                }
                            }
                            catch (Exception e) {
                                BasicTransactionTest.this.fail(e);
                                try {
                                    if (xa != null) {
                                        xa.rollback();
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object object = monitor;
                                    synchronized (object) {
                                        monitor.notifyAll();
                                    }
                                    throw throwable;
                                }
                                Object object = monitor;
                                synchronized (object) {
                                    monitor.notifyAll();
                                    break block42;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (xa != null) {
                                    xa.rollback();
                                }
                            }
                            catch (Throwable throwable2) {
                                Object object = monitor;
                                synchronized (object) {
                                    monitor.notifyAll();
                                }
                                throw throwable2;
                            }
                            Object object = monitor;
                            synchronized (object) {
                                monitor.notifyAll();
                            }
                            throw throwable;
                        }
                        try {
                            if (xa != null) {
                                xa.rollback();
                            }
                        }
                        catch (Throwable throwable) {
                            Object object = monitor;
                            synchronized (object) {
                                monitor.notifyAll();
                            }
                            throw throwable;
                        }
                        Object object = monitor;
                        synchronized (object) {
                            monitor.notifyAll();
                        }
                    }
                }
            });
            try {
                try {
                    Object object = monitor;
                    synchronized (object) {
                        t.start();
                        monitor.wait();
                        this.root.eResource().getResourceSet().getResource(URI.createURI((String)"platform:/plugin/org.eclipse.emf.ecore/model/Ecore.ecore"), true);
                        monitor.notifyAll();
                        monitor.wait();
                        BasicTransactionTest.assertEquals((String)"Got foreign notifications", (int)0, (int)readNotifications.size());
                    }
                }
                catch (Exception e) {
                    this.fail(e);
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notifyAll();
                    }
                    this.domain.removeResourceSetListener((ResourceSetListener)l);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                Object object = monitor;
                synchronized (object) {
                    monitor.notifyAll();
                }
                this.domain.removeResourceSetListener((ResourceSetListener)l);
                throw throwable;
            }
            Object object = monitor;
            synchronized (object) {
                monitor.notifyAll();
            }
            this.domain.removeResourceSetListener((ResourceSetListener)l);
        }
    }
}

