/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.teneo.annotations.parser.AnnotationParserException;
import org.eclipse.emf.teneo.annotations.parser.AnnotationTokenizer;
import org.eclipse.emf.teneo.annotations.parser.ArrayValueNode;
import org.eclipse.emf.teneo.annotations.parser.ComplexNode;
import org.eclipse.emf.teneo.annotations.parser.NamedParserNode;
import org.eclipse.emf.teneo.annotations.parser.PrimitiveValueNode;
import org.eclipse.emf.teneo.annotations.parser.ReferenceValueNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationParser {
    private AnnotationTokenizer annotationTokenizer;
    private List<NamedParserNode> parserNodes = new ArrayList<NamedParserNode>();
    private long expectedToken = Long.MAX_VALUE;

    public List<NamedParserNode> parse(ENamedElement eNamedElement, String content) {
        int token;
        this.annotationTokenizer = new AnnotationTokenizer(eNamedElement, content);
        this.parserNodes.clear();
        while (this.annotationTokenizer.getCurrentToken() != 4096 && (token = this.annotationTokenizer.nextToken()) != 4096) {
            if (token != 2) {
                throw new AnnotationParserException("Only typenames are allowed at the root of the annotation, see _ for the error " + this.annotationTokenizer.getErrorText());
            }
            this.parseTypeName(null);
        }
        return this.parserNodes;
    }

    private void addToParent(NamedParserNode parent, NamedParserNode child) {
        if (parent == null) {
            return;
        }
        if (parent instanceof ComplexNode) {
            ((ComplexNode)parent).getChildren().add(child);
        } else if (parent instanceof ArrayValueNode) {
            ((ArrayValueNode)parent).getChildren().add(child);
        } else if (parent instanceof ReferenceValueNode) {
            ((ReferenceValueNode)parent).setValue(child);
        }
    }

    private void parseTypeName(NamedParserNode pn) {
        ComplexNode cn = new ComplexNode();
        cn.setName(this.annotationTokenizer.getLexeme());
        this.addToParent(pn, cn);
        if (pn == null) {
            this.parserNodes.add(cn);
        }
        int token = this.annotationTokenizer.nextToken();
        switch (token) {
            case 4096: {
                return;
            }
            case 128: {
                this.parseContent(cn);
                break;
            }
            case 2: {
                this.parseTypeName(null);
                break;
            }
            case 512: {
                if (!(pn instanceof ArrayValueNode)) {
                    throw new AnnotationParserException("Encountered comma but not within an array definition, see _ for error location " + this.annotationTokenizer.getErrorText());
                }
                return;
            }
            default: {
                throw new AnnotationParserException("Unknown token, see _ for error position: " + this.annotationTokenizer.getErrorText());
            }
        }
    }

    private void parseContent(NamedParserNode pn) {
        this.expectedToken = 44L;
        boolean finished = false;
        while (!finished) {
            int token = this.annotationTokenizer.nextToken();
            this.checkToken(token);
            switch (token) {
                case 512: {
                    this.expectedToken = 4L;
                    break;
                }
                case 4096: {
                    throw new AnnotationParserException("Unexcepted end to annotation string, " + this.annotationTokenizer.getErrorText());
                }
                case 256: {
                    return;
                }
                case 32: {
                    String theValue = this.annotationTokenizer.getLexeme();
                    PrimitiveValueNode valueNode = new PrimitiveValueNode();
                    valueNode.setName("value");
                    valueNode.setValue(theValue);
                    this.addToParent(pn, valueNode);
                    if (this.annotationTokenizer.nextToken() != 256) {
                        throw new AnnotationParserException("After this value a closing ) should follow " + this.annotationTokenizer.getErrorText());
                    }
                    return;
                }
                case 4: {
                    PrimitiveValueNode vn;
                    String value;
                    String identifier = this.annotationTokenizer.getLexeme();
                    int nextToken = this.annotationTokenizer.nextToken();
                    if (nextToken == 256) {
                        PrimitiveValueNode vn2 = new PrimitiveValueNode();
                        vn2.setName("value");
                        vn2.setValue(identifier);
                        this.addToParent(pn, vn2);
                        return;
                    }
                    if (nextToken != 64) {
                        throw new AnnotationParserException("No = character after identifier, see _ for error position " + this.annotationTokenizer.getErrorText());
                    }
                    nextToken = this.annotationTokenizer.nextToken();
                    if (nextToken == 32) {
                        value = this.annotationTokenizer.getLexeme();
                        vn = new PrimitiveValueNode();
                        vn.setName(identifier);
                        vn.setValue(value);
                        this.addToParent(pn, vn);
                    } else if (nextToken == 4) {
                        value = this.annotationTokenizer.getLexeme();
                        vn = new PrimitiveValueNode();
                        vn.setName(identifier);
                        vn.setValue(value);
                        this.addToParent(pn, vn);
                    } else if (nextToken == 2) {
                        ReferenceValueNode rvn = new ReferenceValueNode();
                        rvn.setName(identifier);
                        this.parseTypeName(rvn);
                        this.addToParent(pn, rvn);
                    } else if (nextToken == 8) {
                        ArrayValueNode avn = new ArrayValueNode();
                        avn.setName(identifier);
                        this.parseArray(avn);
                        this.addToParent(pn, avn);
                    } else if (this.annotationTokenizer.nextToken() != 32) {
                        throw new AnnotationParserException("No value token after =, see _ for error position " + this.annotationTokenizer.getErrorText());
                    }
                    this.expectedToken = 772L;
                    break;
                }
                case 8: {
                    this.parseArray(pn);
                    ((ComplexNode)pn).setList(true);
                    this.expectedToken = 772L;
                }
            }
        }
    }

    private void parseArray(NamedParserNode pn) {
        ArrayValueNode an = new ArrayValueNode();
        this.addToParent(pn, an);
        boolean finished = false;
        this.expectedToken = 38L;
        while (!finished) {
            int token = this.annotationTokenizer.nextToken();
            this.checkToken(token);
            switch (token) {
                case 4096: {
                    throw new AnnotationParserException("Unexcepted end to annotation string, " + this.annotationTokenizer.getErrorText());
                }
                case 2: {
                    this.parseTypeName(an);
                    this.expectedToken = 528L;
                    break;
                }
                case 32: {
                    String value = this.annotationTokenizer.getLexeme();
                    if (value != null && value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    an.getChildren().add(value);
                    this.expectedToken = 528L;
                    break;
                }
                case 4: {
                    an.getChildren().add(this.annotationTokenizer.getLexeme());
                    this.expectedToken = 592L;
                    break;
                }
                case 512: {
                    this.expectedToken = 38L;
                    break;
                }
                case 16: {
                    this.expectedToken = Long.MAX_VALUE;
                    return;
                }
            }
        }
        throw new AnnotationParserException("Unexpected end of array. " + this.annotationTokenizer.getErrorText());
    }

    protected void checkToken(int currentToken) {
        if (((long)currentToken & this.expectedToken) == 0L) {
            String msg = "Found " + this.annotationTokenizer.getCurrentTokenName() + " but expected one of : " + this.annotationTokenizer.getTokenNames(this.expectedToken);
            throw new AnnotationParserException(String.valueOf(msg) + ". " + this.annotationTokenizer.getErrorText());
        }
    }
}

