/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.StoreAnnotationsException;
import org.eclipse.emf.teneo.annotations.mapper.AnnotationGenerator;
import org.eclipse.emf.teneo.annotations.mapper.BasicPamodelBuilder;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceFileProvider;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.parser.EAnnotationParserImporter;
import org.eclipse.emf.teneo.annotations.xml.XmlPersistenceMapper;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceMappingBuilder
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(PersistenceMappingBuilder.class);
    public static final PersistenceMappingBuilder INSTANCE = new PersistenceMappingBuilder();

    public PAnnotatedModel buildMapping(String[] ecoreFiles, PersistenceOptions po, ExtensionManager extensionManager) {
        return this.buildMapping(StoreUtil.readEPackages(ecoreFiles), po, extensionManager);
    }

    public PAnnotatedModel buildMapping(EPackage[] epackages, PersistenceOptions po, ExtensionManager extensionManager) {
        return this.buildMapping(Arrays.asList(epackages), po, extensionManager);
    }

    public PAnnotatedModel buildMapping(List<EPackage> epacks, PersistenceOptions po, ExtensionManager extensionManager) {
        ArrayList<EPackage> epackages = new ArrayList<EPackage>();
        for (EPackage epack : epacks) {
            this.resolveSubPackages(epack, epackages);
        }
        if (po.isAutoAddReferencedEPackages()) {
            ArrayList<EPackage> allEPackages = new ArrayList<EPackage>();
            for (EPackage ePackage : epackages) {
                this.addAllUsedEPackages(ePackage, allEPackages);
            }
            if (epackages.contains(EcorePackage.eINSTANCE)) {
                allEPackages.add((EPackage)EcorePackage.eINSTANCE);
            }
            if (epackages.contains(XMLTypePackage.eINSTANCE)) {
                allEPackages.add((EPackage)XMLTypePackage.eINSTANCE);
            }
            epackages = allEPackages;
        }
        BasicPamodelBuilder pamodelBuilder = extensionManager.getExtension(BasicPamodelBuilder.class);
        log.debug((Object)"Creating pamodel for the following epackages");
        for (EPackage element : epackages) {
            log.debug((Object)element.getName());
            pamodelBuilder.addRecurse(element);
        }
        if (po.isMapDocumentRoot()) {
            EPackage ecorePackage = PackageRegistryProvider.getInstance().getPackageRegistry().getEPackage("http://www.eclipse.org/emf/2002/Ecore");
            EClassifier eClassifier = ecorePackage.getEClassifier(EcorePackage.eINSTANCE.getEStringToStringMapEntry().getName());
            pamodelBuilder.addSpecificEClass((EClass)eClassifier);
        }
        log.debug((Object)"Create base pannotated model");
        PAnnotatedModel pam = pamodelBuilder.getPAnnotatedModel();
        log.debug((Object)"Deprecated eannotations with http://annotations.elver.org or http://ejb.elver.org are ignored.");
        if (po.isIgnoreEAnnotations()) {
            log.debug((Object)"Ignoring annotations");
        } else {
            log.debug((Object)"Parse annotations");
            EAnnotationParserImporter parserImporter = extensionManager.getExtension(EAnnotationParserImporter.class);
            parserImporter.setExtraAnnotationSources(po);
            parserImporter.process(pam);
        }
        if (po.getPersistenceXmlPath() != null) {
            try {
                InputStream[] iss;
                PersistenceFileProvider fileProvider = extensionManager.getExtension(PersistenceFileProvider.class);
                InputStream in = fileProvider.getFileContent(null, po.getPersistenceXmlPath());
                if (in == null) {
                    throw new RuntimeException("Could not find persistence XML resource in classpath: \"" + po.getPersistenceXmlPath() + "\".");
                }
                XmlPersistenceMapper xmlPersistenceMapper = extensionManager.getExtension(XmlPersistenceMapper.class);
                xmlPersistenceMapper.setXmlMapping(in);
                xmlPersistenceMapper.applyPersistenceMapping(pam);
                in.close();
                InputStream[] inputStreamArray = iss = this.getAdditionalXMLMappings();
                int n = iss.length;
                int n2 = 0;
                while (n2 < n) {
                    InputStream element = inputStreamArray[n2];
                    xmlPersistenceMapper.setXmlMapping(element);
                    xmlPersistenceMapper.applyPersistenceMapping(pam);
                    element.close();
                    ++n2;
                }
            }
            catch (IOException e) {
                throw new StoreAnnotationsException("Exception while loading xml persistence mappings", e);
            }
        }
        this.processEDataTypeAnnotations(pam);
        log.debug((Object)"Add default annotations");
        pam.setInitialized(true);
        extensionManager.getExtension(AnnotationGenerator.class).map(pam, po);
        log.debug((Object)"Returning created pamodel");
        return pam;
    }

    private void resolveSubPackages(EPackage epack, List<EPackage> epacks) {
        if (!epacks.contains(epack)) {
            epacks.add(epack);
        }
        for (EPackage subEPackage : epack.getESubpackages()) {
            this.resolveSubPackages(subEPackage, epacks);
        }
    }

    private void addAllUsedEPackages(EPackage eCurrentEPackage, List<EPackage> ePackages) {
        if (eCurrentEPackage == null) {
            return;
        }
        if (ePackages.contains(eCurrentEPackage)) {
            return;
        }
        if (eCurrentEPackage instanceof EcorePackage || eCurrentEPackage instanceof XMLTypePackage) {
            return;
        }
        ePackages.add(eCurrentEPackage);
        this.addAllUsedEPackages(eCurrentEPackage.getESuperPackage(), ePackages);
        for (EPackage subPackage : eCurrentEPackage.getESubpackages()) {
            this.addAllUsedEPackages(subPackage, ePackages);
        }
        for (EClassifier eClassifier : eCurrentEPackage.getEClassifiers()) {
            this.addAllUsedEPackages(eClassifier, ePackages);
        }
    }

    private void addAllUsedEPackages(EClassifier eClassifier, List<EPackage> ePackages) {
        if (eClassifier instanceof EClass) {
            this.addAllUsedEPackages((EClass)eClassifier, ePackages);
        } else {
            this.addAllUsedEPackages((EDataType)eClassifier, ePackages);
        }
    }

    private void addAllUsedEPackages(EClass eClass, List<EPackage> ePackages) {
        this.addAllUsedEPackages(eClass.getEPackage(), ePackages);
        for (EClass eSuperClass : eClass.getESuperTypes()) {
            if (ePackages.contains(eSuperClass.getEPackage())) continue;
            this.addAllUsedEPackages(eSuperClass, ePackages);
        }
        for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
            if (ePackages.contains(eFeature.getEType().getEPackage())) continue;
            this.addAllUsedEPackages(eFeature.getEType(), ePackages);
        }
    }

    private void addAllUsedEPackages(EDataType eDataType, List<EPackage> ePackages) {
        if (eDataType == null) {
            return;
        }
        this.addAllUsedEPackages(eDataType.getEPackage(), ePackages);
        this.addAllUsedEPackages(ExtendedMetaData.INSTANCE.getBaseType(eDataType), ePackages);
    }

    protected void processEDataTypeAnnotations(PAnnotatedModel pam) {
        log.debug((Object)"Copying annotations on edatatypes over eattribute annotations!");
        for (PAnnotatedEPackage pep : pam.getPaEPackages()) {
            for (PAnnotatedEClass pec : pep.getPaEClasses()) {
                for (PAnnotatedEStructuralFeature pef : pec.getPaEStructuralFeatures()) {
                    PAnnotatedEAttribute pea;
                    EDataType et;
                    PAnnotatedEDataType ped;
                    if (!(pef instanceof PAnnotatedEAttribute) || (ped = pam.getPAnnotated(et = (pea = (PAnnotatedEAttribute)pef).getModelEAttribute().getEAttributeType())) == null) continue;
                    for (EStructuralFeature esf : ped.eClass().getEAllStructuralFeatures()) {
                        EStructuralFeature asf = pea.eClass().getEStructuralFeature(esf.getName());
                        if (asf == null || pea.eIsSet(asf) || !ped.eIsSet(esf)) continue;
                        log.debug((Object)("Copying value for feature " + esf.getName() + " from edatatype " + et.getName() + " to " + pea.getModelEAttribute().getName()));
                        Object obj = ped.eGet(esf);
                        if (obj instanceof Collection) {
                            pea.eSet(asf, (Object)EcoreUtil.copyAll((Collection)((Collection)obj)));
                            continue;
                        }
                        if (obj instanceof EObject) {
                            pea.eSet(asf, (Object)EcoreUtil.copy((EObject)((EObject)obj)));
                            continue;
                        }
                        throw new StoreAnnotationsException("Class " + obj.getClass().getName() + " not supported should be eobject or collection");
                    }
                }
            }
        }
    }

    protected InputStream[] getAdditionalXMLMappings() {
        return new InputStream[0];
    }
}

