/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.strategy.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.mapping.strategy.SQLNameStrategy;
import org.eclipse.emf.teneo.mapping.strategy.StrategyUtil;
import org.eclipse.emf.teneo.mapping.strategy.impl.ClassicEntityNameStrategy;
import org.eclipse.emf.teneo.util.AssertUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicSQLNameStrategy
implements SQLNameStrategy,
ExtensionManagerAware {
    protected static final Log log = LogFactory.getLog(ClassicSQLNameStrategy.class);
    protected String optionJoinTableNamingStrategy;
    protected String optionJoinColumnNamingStrategy;
    protected int optionMaximumSqlLength;
    protected EntityNameStrategy entityNameStrategy;
    protected PersistenceOptions persistenceOptions;
    protected boolean optionSQLUpperCase = false;
    protected boolean optionSQLLowerCase = false;
    protected String optionTableNamePrefix = "";
    protected String optionColumnNamePrefix = "";
    protected String optionForeignKeyNamePrefix = "";
    protected String optionSQLNameColumnPrefix = "";
    private ExtensionManager extensionManager;

    @Override
    public String getPrimaryKeyJoinColumnName(PAnnotatedEClass aSuperClass, String idFeature) {
        return String.valueOf(this.optionColumnNamePrefix) + this.convert(String.valueOf(this.getEntityName(aSuperClass.getPaModel(), aSuperClass.getModelEClass())) + "_" + idFeature, true);
    }

    @Override
    public String getSecondaryTablePrimaryKeyJoinColumnName(PAnnotatedEStructuralFeature iddef) {
        return String.valueOf(this.optionColumnNamePrefix) + this.convert(iddef.getModelEStructuralFeature().getName());
    }

    @Override
    public String getTableName(PAnnotatedEClass aClass) {
        return String.valueOf(this.optionTableNamePrefix) + this.convert(this.getEntityName(aClass.getPaModel(), aClass.getModelEClass()));
    }

    @Override
    public String getColumnName(PAnnotatedEStructuralFeature aStructuralFeature, String prefix) {
        if (prefix != null) {
            return this.convert(String.valueOf(prefix) + "_" + aStructuralFeature.getModelEStructuralFeature().getName());
        }
        return String.valueOf(this.optionColumnNamePrefix) + this.convert(aStructuralFeature.getModelEStructuralFeature().getName());
    }

    @Override
    public String getForeignKeyName(PAnnotatedEStructuralFeature aFeature) {
        PAnnotatedEClass aClass = aFeature.getPaEClass();
        return String.valueOf(this.optionForeignKeyNamePrefix) + this.convert(String.valueOf(this.getEntityName(aClass.getPaModel(), aClass.getModelEClass())) + "_" + aFeature.getModelEStructuralFeature().getName(), true);
    }

    @Override
    public List<String> getManyToOneJoinColumnNames(PAnnotatedEReference aReference) {
        EReference eref = aReference.getModelEReference();
        assert (eref.isTransient() || !eref.isMany());
        PAnnotatedEClass aClass = eref.getEOpposite() == null ? aReference.getAReferenceType() : aReference.getPaEClass();
        String typeName = this.getMappingName(aClass);
        String featureName = eref.getName();
        ArrayList<String> result = new ArrayList<String>();
        List<String> names = StrategyUtil.getIDFeaturesNames(aClass, this.persistenceOptions.getDefaultIDFeatureName());
        boolean simpleNaming = this.optionJoinColumnNamingStrategy.compareTo("simple") == 0;
        for (String name : names) {
            String postFix = names.size() == 1 && simpleNaming ? "" : "_" + name;
            String jcName = simpleNaming ? String.valueOf(featureName) + postFix : String.valueOf(typeName) + "_" + featureName + postFix;
            result.add(String.valueOf(this.optionColumnNamePrefix) + this.convert(jcName, true));
        }
        return result;
    }

    @Override
    public List<String> getOneToManyEAttributeJoinColumns(PAnnotatedEAttribute aAttribute) {
        PAnnotatedEClass aClass = aAttribute.getPaEClass();
        String typeName = this.getMappingName(aClass);
        String featureName = aAttribute.getModelEAttribute().getName();
        ArrayList<String> result = new ArrayList<String>();
        List<String> names = StrategyUtil.getIDFeaturesNames(aClass, this.persistenceOptions.getDefaultIDFeatureName());
        boolean simpleNaming = this.optionJoinColumnNamingStrategy.compareTo("simple") == 0;
        for (String name : names) {
            String postFix = names.size() == 1 && simpleNaming ? "" : "_" + name;
            String jcName = String.valueOf(typeName) + "_" + featureName + postFix;
            result.add(String.valueOf(this.optionColumnNamePrefix) + this.convert(jcName, true));
        }
        return result;
    }

    @Override
    public List<String> getOneToManyEReferenceJoinColumns(PAnnotatedEReference aReference) {
        String featureName;
        String typeName;
        PAnnotatedEClass aClass = aReference.getPaEClass();
        if (aReference.getModelEReference().getEOpposite() != null) {
            typeName = this.getMappingName(aReference.getAReferenceType());
            featureName = aReference.getModelEReference().getEOpposite().getName();
        } else {
            typeName = this.getMappingName(aClass);
            featureName = aReference.getModelEReference().getName();
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> names = StrategyUtil.getIDFeaturesNames(aClass, this.persistenceOptions.getDefaultIDFeatureName());
        boolean simpleNaming = this.optionJoinColumnNamingStrategy.compareTo("simple") == 0;
        for (String name : names) {
            String postFix = names.size() == 1 && simpleNaming ? "" : "_" + name;
            String jcName = String.valueOf(typeName) + "_" + featureName + postFix;
            result.add(String.valueOf(this.optionColumnNamePrefix) + this.convert(jcName, true));
        }
        return result;
    }

    @Override
    public List<String> getJoinTableJoinColumns(PAnnotatedEReference aReference, boolean inverse) {
        String featureName;
        String typeName;
        PAnnotatedEClass aClass;
        if (inverse) {
            aClass = aReference.getAReferenceType();
            if (aReference.getModelEReference().getEOpposite() != null) {
                typeName = this.getMappingName(aReference.getAReferenceType());
                featureName = "_" + aReference.getModelEReference().getEOpposite().getName();
            } else {
                typeName = this.getMappingName(aReference.getAReferenceType());
                featureName = "";
            }
        } else {
            aClass = aReference.getPaEClass();
            typeName = this.getMappingName(aClass);
            featureName = "_" + aReference.getModelEReference().getName();
        }
        if (aReference.getAReferenceType() != aReference.getPaEClass()) {
            featureName = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> names = StrategyUtil.getIDFeaturesNames(aClass, this.persistenceOptions.getDefaultIDFeatureName());
        boolean simpleNaming = this.optionJoinColumnNamingStrategy.compareTo("simple") == 0;
        for (String name : names) {
            String postFix = names.size() == 1 && simpleNaming ? "" : "_" + name;
            String jcName = String.valueOf(typeName) + featureName + postFix;
            result.add(String.valueOf(this.optionColumnNamePrefix) + this.convert(jcName, true));
        }
        return result;
    }

    @Override
    public String getJoinTableName(PAnnotatedEAttribute aAttribute) {
        PAnnotatedEClass aClass = aAttribute.getPaEClass();
        String truncedName = String.valueOf(this.getEntityName(aClass.getPaModel(), aClass.getModelEClass())) + "_" + aAttribute.getModelEAttribute().getName();
        return String.valueOf(this.optionTableNamePrefix) + this.convert(truncedName, true);
    }

    @Override
    public String getJoinTableName(PAnnotatedEReference aReference) {
        String jTableName;
        EReference eReference = aReference.getModelEReference();
        boolean isEObject = eReference.getEType() == ClassicEntityNameStrategy.EOBJECT_ECLASS;
        EReference eOpposite = eReference.getEOpposite();
        if (aReference.getManyToMany() != null && aReference.getManyToMany().isIndexed()) {
            eOpposite = null;
        }
        if (!isEObject && this.optionJoinTableNamingStrategy.compareToIgnoreCase("ejb3") == 0) {
            String thisEntityName = this.getEntityName(aReference.getPaModel(), eReference.getEContainingClass());
            String thatEntityName = this.getEntityName(aReference.getPaModel(), eReference.getEReferenceType());
            jTableName = eOpposite != null && eOpposite.isMany() && this.compareNames(eReference, eOpposite) ? String.valueOf(thatEntityName) + "_" + thisEntityName : String.valueOf(thisEntityName) + "_" + thatEntityName;
        } else {
            AssertUtil.assertTrue("option optionJoinTableNamingStrategy " + this.optionJoinTableNamingStrategy + " not supported", isEObject || this.optionJoinTableNamingStrategy.compareToIgnoreCase("unique") == 0);
            if (eOpposite != null && eOpposite.isMany() && this.compareNames(eReference, eOpposite)) {
                String thatEntityName = this.getEntityName(aReference.getPaModel(), eOpposite.getEContainingClass());
                jTableName = String.valueOf(thatEntityName) + "_" + eOpposite.getName();
            } else {
                String thisEntityName = this.getEntityName(aReference.getPaModel(), eReference.getEContainingClass());
                jTableName = String.valueOf(thisEntityName) + "_" + eReference.getName();
            }
        }
        return String.valueOf(this.optionTableNamePrefix) + this.convert(jTableName);
    }

    @Override
    public String getDiscriminatorColumnName() {
        return String.valueOf(this.optionColumnNamePrefix) + this.convert("DTYPE");
    }

    @Override
    public String getVersionColumnName() {
        return String.valueOf(this.optionColumnNamePrefix) + this.convert(this.persistenceOptions.getVersionColumnName());
    }

    @Override
    public String getIdBagIDColumn() {
        return String.valueOf(this.optionColumnNamePrefix) + this.convert(this.persistenceOptions.getIDBagIDColumnName());
    }

    @Override
    public String getSyntheticIDColumnName() {
        return String.valueOf(this.optionColumnNamePrefix) + this.convert(this.persistenceOptions.getIdColumnName());
    }

    @Override
    public void setPersistenceOptions(PersistenceOptions po) {
        this.optionMaximumSqlLength = po.getMaximumSqlNameLength();
        this.optionJoinTableNamingStrategy = po.getJoinTableNamingStrategy();
        this.optionJoinColumnNamingStrategy = po.getJoinColumnNamingStrategy();
        String optionSQLCaseStrategy = po.getSQLCaseStrategy();
        if (optionSQLCaseStrategy.toLowerCase().compareTo("lowercase") == 0) {
            this.optionSQLLowerCase = true;
        } else if (optionSQLCaseStrategy.toLowerCase().compareTo("uppercase") == 0) {
            this.optionSQLUpperCase = true;
        }
        this.optionTableNamePrefix = po.getSQLTableNamePrefix();
        this.optionColumnNamePrefix = po.getSQLColumnNamePrefix();
        this.optionForeignKeyNamePrefix = po.getSQLForeignKeyNamePrefix();
        this.optionSQLNameColumnPrefix = po.getSQLColumnNamePrefix();
        this.persistenceOptions = po;
    }

    private String getEntityName(PAnnotatedModel paModel, EClass eClass) {
        return StrategyUtil.getEntityName(this.getEntityNameStrategy(), this.persistenceOptions, paModel, eClass);
    }

    protected String getMappingName(PAnnotatedEClass aClass) {
        return aClass.getModelEClass().getName();
    }

    public String getIndexColumnName(PAnnotatedEStructuralFeature aFeature) {
        return String.valueOf(this.optionSQLNameColumnPrefix) + (String.valueOf(this.getMappingName(aFeature.getPaEClass())) + "_" + aFeature.getModelEStructuralFeature().getName() + "_IDX").toUpperCase();
    }

    @Override
    public String convert(String name) {
        return this.convert(name, false);
    }

    @Override
    public String convert(String name, boolean truncPrefix) {
        String result = this.trunc(this.optionMaximumSqlLength, name, truncPrefix);
        if (this.optionSQLLowerCase) {
            return result.toLowerCase();
        }
        if (this.optionSQLUpperCase) {
            return result.toUpperCase();
        }
        return result;
    }

    private boolean compareNames(EReference here, EReference there) {
        String nameHere = String.valueOf(here.getEContainingClass().getName()) + here.getName();
        String nameThere = String.valueOf(there.getEContainingClass().getName()) + there.getName();
        assert (nameHere.compareTo(nameThere) != 0);
        return nameHere.compareTo(nameThere) > 0;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public EntityNameStrategy getEntityNameStrategy() {
        if (this.entityNameStrategy == null) {
            this.entityNameStrategy = this.getExtensionManager().getExtension(EntityNameStrategy.class);
        }
        return this.entityNameStrategy;
    }

    protected String trunc(int optionMaximumSqlLength, String truncName, boolean truncPrefix) {
        String correctedName = truncName.replace('.', '_');
        if (optionMaximumSqlLength == -1) {
            return correctedName;
        }
        if (correctedName.length() < optionMaximumSqlLength) {
            return correctedName;
        }
        if (!truncPrefix) {
            return correctedName.substring(0, optionMaximumSqlLength);
        }
        int underscore = correctedName.lastIndexOf(95);
        if (underscore != -1 && underscore > 0) {
            String usStr = correctedName.substring(underscore);
            if (optionMaximumSqlLength - usStr.length() < 0) {
                return correctedName;
            }
            return String.valueOf(correctedName.substring(0, optionMaximumSqlLength - usStr.length())) + usStr;
        }
        return correctedName.substring(0, optionMaximumSqlLength);
    }
}

