/*
 * Decompiled with CFR 0.152.
 */
package org.example.mindmap.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.example.mindmap.DocumentRoot;
import org.example.mindmap.Map;
import org.example.mindmap.MindmapFactory;
import org.example.mindmap.MindmapPackage;
import org.example.mindmap.Priority;
import org.example.mindmap.Relationship;
import org.example.mindmap.RelationshipType;
import org.example.mindmap.Resource;
import org.example.mindmap.Thread;
import org.example.mindmap.ThreadItem;
import org.example.mindmap.Topic;
import org.example.mindmap.impl.DocumentRootImpl;
import org.example.mindmap.impl.MapImpl;
import org.example.mindmap.impl.RelationshipImpl;
import org.example.mindmap.impl.ResourceImpl;
import org.example.mindmap.impl.ThreadImpl;
import org.example.mindmap.impl.ThreadItemImpl;
import org.example.mindmap.impl.TopicImpl;

public class MindmapFactoryImpl
extends EFactoryImpl
implements MindmapFactory {
    public static MindmapFactory init() {
        try {
            MindmapFactory theMindmapFactory = (MindmapFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.example.org/mindmap");
            if (theMindmapFactory != null) {
                return theMindmapFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MindmapFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDocumentRoot();
            }
            case 1: {
                return this.createMap();
            }
            case 2: {
                return this.createRelationship();
            }
            case 3: {
                return this.createResource();
            }
            case 4: {
                return this.createThread();
            }
            case 5: {
                return this.createThreadItem();
            }
            case 6: {
                return this.createTopic();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.createPriorityFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createRelationshipTypeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createPriorityObjectFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createRelationshipTypeObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.convertPriorityToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertRelationshipTypeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertPriorityObjectToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertRelationshipTypeObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public DocumentRoot createDocumentRoot() {
        DocumentRootImpl documentRoot = new DocumentRootImpl();
        return documentRoot;
    }

    public Map createMap() {
        MapImpl map = new MapImpl();
        return map;
    }

    public Relationship createRelationship() {
        RelationshipImpl relationship = new RelationshipImpl();
        return relationship;
    }

    public Resource createResource() {
        ResourceImpl resource = new ResourceImpl();
        return resource;
    }

    public Thread createThread() {
        ThreadImpl thread = new ThreadImpl();
        return thread;
    }

    public ThreadItem createThreadItem() {
        ThreadItemImpl threadItem = new ThreadItemImpl();
        return threadItem;
    }

    public Topic createTopic() {
        TopicImpl topic = new TopicImpl();
        return topic;
    }

    public Priority createPriorityFromString(EDataType eDataType, String initialValue) {
        Priority result = Priority.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertPriorityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RelationshipType createRelationshipTypeFromString(EDataType eDataType, String initialValue) {
        RelationshipType result = RelationshipType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRelationshipTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Priority createPriorityObjectFromString(EDataType eDataType, String initialValue) {
        return this.createPriorityFromString((EDataType)MindmapPackage.Literals.PRIORITY, initialValue);
    }

    public String convertPriorityObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertPriorityToString((EDataType)MindmapPackage.Literals.PRIORITY, instanceValue);
    }

    public RelationshipType createRelationshipTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createRelationshipTypeFromString((EDataType)MindmapPackage.Literals.RELATIONSHIP_TYPE, initialValue);
    }

    public String convertRelationshipTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertRelationshipTypeToString((EDataType)MindmapPackage.Literals.RELATIONSHIP_TYPE, instanceValue);
    }

    public MindmapPackage getMindmapPackage() {
        return (MindmapPackage)this.getEPackage();
    }

    public static MindmapPackage getPackage() {
        return MindmapPackage.eINSTANCE;
    }
}

