/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.extension;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.classloader.ClassLoaderResolver;
import org.eclipse.emf.teneo.extension.Extension;
import org.eclipse.emf.teneo.extension.ExtensionInitializable;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.extension.ExtensionUtil;
import org.eclipse.emf.teneo.extension.TeneoExtensionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExtensionManager
implements ExtensionManager {
    private static Log log = LogFactory.getLog(DefaultExtensionManager.class);
    private ConcurrentHashMap<String, Extension> extensionRegistry = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ExtensionPoint> extensionInstances = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Constructor<?>> constructorCache = new ConcurrentHashMap();

    public DefaultExtensionManager() {
        ExtensionUtil.registerDefaultExtensions(this);
    }

    @Override
    public void registerExtension(Extension extension) {
        Extension currentExtension;
        if (extension.isDefaultExtension() && (currentExtension = this.extensionRegistry.get(extension.getPoint())) != null && !currentExtension.isDefaultExtension()) {
            log.debug((Object)("Not registering extension " + extension));
            log.debug((Object)("There is already a user plugin defined: " + currentExtension));
            return;
        }
        if (extension.getPoint() == null) {
            throw new TeneoExtensionException("Point of extension may not be null");
        }
        if (extension.getClassName() == null) {
            throw new TeneoExtensionException("Classname of extension: " + extension.getPoint() + " may not be null");
        }
        log.debug((Object)("Registering " + extension));
        this.extensionRegistry.put(extension.getPoint(), extension);
        this.extensionInstances.remove(extension.getPoint());
    }

    @Override
    public void registerExtension(String point, String className) {
        Extension currentExtension = this.extensionRegistry.get(point);
        if (currentExtension == null) {
            throw new TeneoExtensionException("No default extension found using point: " + point + " is the point value correct?");
        }
        Extension newExtension = new Extension();
        newExtension.setPoint(point);
        newExtension.setClassName(className);
        newExtension.setDefaultExtension(false);
        newExtension.setSingleton(currentExtension.isSingleton());
        this.registerExtension(newExtension);
    }

    @Override
    public ExtensionPoint getExtension(String point, Object[] initArgs) {
        ExtensionPoint extensionInstance;
        log.debug((Object)("Searching extension " + point));
        Extension extension = this.extensionRegistry.get(point);
        if (extension == null) {
            throw new TeneoExtensionException("Extension point " + point + " not registered");
        }
        if (extension.isSingleton() && (extensionInstance = this.extensionInstances.get(point)) != null) {
            log.debug((Object)("Found instance " + extensionInstance.getClass().getClass()));
            return extensionInstance;
        }
        Class<?> clz = ClassLoaderResolver.classForName(extension.getClassName());
        if (!ExtensionPoint.class.isAssignableFrom(clz)) {
            throw new TeneoExtensionException("The requested extension " + clz.getName() + " does not implement the interface " + ExtensionPoint.class.getName());
        }
        try {
            ExtensionPoint extensionInstance2;
            boolean constructorUsed;
            if (initArgs == null || initArgs.length == 0) {
                constructorUsed = false;
                extensionInstance2 = (ExtensionPoint)clz.newInstance();
            } else {
                log.debug((Object)("Initargs passed, using constructor for class " + clz.getName()));
                constructorUsed = true;
                Constructor<?> constructor = this.getConstructor(clz, initArgs);
                extensionInstance2 = (ExtensionPoint)constructor.newInstance(initArgs);
            }
            log.debug((Object)("Created extensionPoint instance: " + extensionInstance2.getClass().getName()));
            if (extensionInstance2 instanceof ExtensionManagerAware) {
                ((ExtensionManagerAware)((Object)extensionInstance2)).setExtensionManager(this);
            }
            if (extensionInstance2 instanceof ExtensionInitializable) {
                log.debug((Object)("Initializing extension " + extensionInstance2.getClass().getName()));
                ((ExtensionInitializable)((Object)extensionInstance2)).initializeExtension();
            }
            if (extension.isSingleton() && !constructorUsed) {
                log.debug((Object)("Caching extension instance as singleton " + extension));
                this.extensionInstances.put(point, extensionInstance2);
                this.registerForAllExtensionPoints(extensionInstance2.getClass(), extensionInstance2);
            }
            if (extension.isSingleton() && constructorUsed) {
                log.warn((Object)("The extension: " + extension.getPoint() + " is declared as a singleton but this getInstance call " + " passed initialization parameters so it is not cached, " + clz.getName()));
            }
            return extensionInstance2;
        }
        catch (Exception e) {
            throw new TeneoExtensionException("Exception while instantiating: " + extension.getClassName(), e);
        }
    }

    protected Constructor<?> getConstructor(Class<?> clz, Object[] initArgs) throws NoSuchMethodException {
        Constructor<?> result = null;
        Class[] initTypes = new Class[initArgs.length];
        int i = 0;
        StringBuffer keyStr = new StringBuffer();
        Object[] objectArray = initArgs;
        int n = initArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (keyStr.length() > 0) {
                keyStr.append(",");
            }
            if (o == null) {
                initTypes[i++] = null;
                keyStr.append("null");
            } else {
                initTypes[i++] = o.getClass();
                keyStr.append(o.getClass().getName());
            }
            ++n2;
        }
        String key = String.valueOf(clz.getName()) + keyStr;
        result = this.constructorCache.get(key);
        if (result != null) {
            return result;
        }
        Constructor<?>[] constructorArray = clz.getConstructors();
        int n3 = constructorArray.length;
        n = 0;
        while (n < n3) {
            Constructor<?> constructor = constructorArray[n];
            if (constructor.getParameterTypes().length == initTypes.length) {
                int j = 0;
                boolean found = true;
                Class<?>[] classArray = constructor.getParameterTypes();
                int n4 = classArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Class argumentType;
                    Class<?> paramType = classArray[n5];
                    if ((argumentType = initTypes[j++]) == null && !Object.class.isAssignableFrom(paramType)) {
                        found = false;
                        break;
                    }
                    if (!(argumentType == null && Object.class.isAssignableFrom(paramType) || paramType.isAssignableFrom(argumentType))) {
                        found = false;
                        break;
                    }
                    ++n5;
                }
                if (found) {
                    result = constructor;
                    this.constructorCache.put(key, result);
                    break;
                }
            }
            ++n;
        }
        if (result == null) {
            throw new TeneoExtensionException("No constructor found for : " + clz.getName() + " and constructor argument types: " + keyStr);
        }
        return result;
    }

    @Override
    public <T> T getExtension(Class<T> clz) {
        return (T)this.getExtension(clz.getName(), null);
    }

    @Override
    public <T> T getExtension(Class<T> clz, Object[] initArgs) {
        return (T)this.getExtension(clz.getName(), initArgs);
    }

    private void registerForAllExtensionPoints(Class<?> cls, ExtensionPoint extensionInstance) {
        if (cls == null) {
            return;
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interf = classArray[n2];
            this.checkRegister(this.extensionRegistry.get(interf.getName()), extensionInstance);
            ++n2;
        }
        this.checkRegister(this.extensionRegistry.get(cls.getName()), extensionInstance);
        this.registerForAllExtensionPoints(cls.getSuperclass(), extensionInstance);
    }

    private void checkRegister(Extension extension, ExtensionPoint extensionInstance) {
        if (extension == null) {
            return;
        }
        if (extension.getClassName().compareTo(extensionInstance.getClass().getName()) == 0 && extension.isSingleton() && this.extensionInstances.get(extension.getPoint()) == null) {
            log.debug((Object)("Also registering extensioninstance: " + extensionInstance.getClass().getName() + " for extension " + extension.getPoint()));
            this.extensionInstances.put(extension.getPoint(), extensionInstance);
        }
    }
}

