/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.teneo.hibernate.EMFInterceptor;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbSessionWrapper;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierUtil;
import org.eclipse.emf.teneo.hibernate.resource.HbResource;
import org.eclipse.emf.teneo.hibernate.resource.SessionController;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.SessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateResource
extends StoreResource
implements HbResource {
    private static Log log = LogFactory.getLog(HibernateResource.class);
    private static String SEPARATOR = "|";
    protected HbDataStore emfDataStore;
    public static String SESSION_CONTROLLER_PARAM = "sessionController";
    protected SessionWrapper sessionWrapper = null;
    protected SessionController sessionController = null;
    private boolean hasSessionController = false;

    public HibernateResource(URI uri) {
        super(uri);
        log.debug((Object)("Creating hibernateresource using uri: " + uri.toString()));
        Map params = this.decodeQueryString(uri.query());
        if (params.get("dsname") != null) {
            this.setDefinedQueries(this.getQueries(params));
            this.emfDataStore = HbHelper.INSTANCE.getDataStore(this.getParam(params, "dsname", uri.query()));
        } else if (params.get(SESSION_CONTROLLER_PARAM) != null) {
            this.setDefinedQueries(this.getQueries(params));
            String scName = this.getParam(params, SESSION_CONTROLLER_PARAM, uri.query());
            this.sessionController = SessionController.getSessionController(scName);
            log.debug((Object)("Using session controller " + scName));
            this.emfDataStore = this.sessionController.getHbDataStore();
            this.hasSessionController = true;
        } else if (uri.fileExtension() != null) {
            log.debug((Object)("Trying fileextension: " + uri.fileExtension()));
            this.emfDataStore = HbHelper.INSTANCE.getDataStore(uri.fileExtension());
            if (this.emfDataStore == null) {
                log.debug((Object)("No datastore defined for extension, assuming this is a property file " + uri.toString()));
                try {
                    URIConverter uriConverter = this.getURIConverter();
                    InputStream is = uriConverter.createInputStream(uri);
                    Properties props = new Properties();
                    props.load(is);
                    is.close();
                    this.emfDataStore = HbUtil.getCreateDataStore(props);
                    this.setDefinedQueries(this.getQueries(props));
                }
                catch (IOException e) {
                    throw new HbMapperException("Exception when reading properties from: " + uri.toString(), (Throwable)e);
                }
            }
        }
        if (this.emfDataStore == null) {
            throw new HbMapperException("No HbDataStore can be found using the uri " + uri.toString());
        }
        log.debug((Object)("Using emf data store using  " + this.emfDataStore.getName()));
        super.init(this.emfDataStore.getTopEntities());
    }

    public HbDataStore getEMFDataStore() {
        return this.emfDataStore;
    }

    @Override
    @Deprecated
    public Session getSession() {
        return (Session)this.getSessionWrapper().getSession();
    }

    @Override
    public SessionWrapper getSessionWrapper() {
        if (this.sessionWrapper == null) {
            if (this.hasSessionController) {
                this.sessionWrapper = this.sessionController.getSessionWrapper();
            } else {
                this.sessionWrapper = this.emfDataStore.createSessionWrapper();
                this.sessionWrapper.setFlushModeManual();
            }
        }
        return this.sessionWrapper;
    }

    @Deprecated
    public void setSession(Session session) {
        this.sessionWrapper = session != null ? new HbSessionWrapper(this.emfDataStore, session) : null;
    }

    protected EObject getEObjectByID(String id) {
        String[] parts;
        EObject firstCheck;
        if (id == null) {
            return super.getEObjectByID(id);
        }
        if (this.getIntrinsicIDToEObjectMap() != null && (firstCheck = (EObject)this.getIntrinsicIDToEObjectMap().get(id)) != null) {
            return firstCheck;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading eobject using urifragment " + id));
        }
        if ((parts = id.split("\\" + SEPARATOR)).length != 2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not a valid urifragment (" + id + ") for the hibernate resource, trying the superclass"));
            }
            return super.getEObjectByID(id);
        }
        EClass eclass = this.emfDataStore.getEntityNameStrategy().toEClass(parts[0]);
        int splitIndex = parts[1].indexOf("=");
        if (splitIndex == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not a valid urifragment (" + id + ") for the hibernate resource, trying the superclass"));
            }
            return super.getEObjectByID(id);
        }
        String idStr = parts[1].substring(1 + splitIndex);
        EObject eObject = super.getEObjectByID(idStr);
        if (eObject != null) {
            return eObject;
        }
        boolean oldLoading = this.isLoading();
        boolean err = true;
        try {
            Object result;
            this.setIsLoading(true);
            if (!this.hasSessionController) {
                this.getSessionWrapper().beginTransaction();
            }
            if ((result = this.getSessionWrapper().get(parts[0], (Serializable)HbUtil.stringToId(eclass, this.emfDataStore, idStr))) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Object not found in the db, trying the parent");
                }
                err = false;
                EObject eObject2 = super.getEObjectByID(id);
                return eObject2;
            }
            InternalEObject internalEObject = (InternalEObject)result;
            if (internalEObject.eResource() == null) {
                this.addUsingContainmentStructure((InternalEObject)result);
            }
            err = false;
            EObject eObject3 = (EObject)result;
            return eObject3;
        }
        finally {
            this.setIsLoading(oldLoading);
            if (!this.hasSessionController) {
                if (err) {
                    this.getSessionWrapper().rollbackTransaction();
                    this.getSessionWrapper().close();
                } else {
                    this.getSessionWrapper().commitTransaction();
                }
            }
        }
    }

    public String getURIFragment(EObject object) {
        if (object == null) {
            return null;
        }
        String theId = HbUtil.idToString(object, this.emfDataStore);
        if (theId == null) {
            return super.getURIFragment(object);
        }
        StringBuffer idStr = new StringBuffer();
        idStr.append(this.emfDataStore.getEntityNameStrategy().toEntityName(object.eClass()));
        idStr.append(SEPARATOR);
        idStr.append("id=" + theId);
        return idStr.toString();
    }

    public void setSessionWrapper(SessionWrapper sessionWrapper) {
        this.sessionWrapper = sessionWrapper;
    }

    @Override
    public void returnSession(Session theSession) {
    }

    @Override
    public void returnSessionWrapper(SessionWrapper sessionWrapper) {
    }

    public Object[] getCrossReferencers(EObject referedTo) {
        boolean err = true;
        SessionWrapper mySessionWrapper = this.getSessionWrapper();
        try {
            if (!this.hasSessionController) {
                mySessionWrapper.beginTransaction();
            }
            Object[] result = this.emfDataStore.getCrossReferencers(mySessionWrapper, (Object)referedTo);
            err = false;
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new HbMapperException("Exception when doing cross reference search " + this.emfDataStore.getName(), (Throwable)e);
        }
        finally {
            if (!this.hasSessionController) {
                if (err) {
                    mySessionWrapper.rollbackTransaction();
                    mySessionWrapper.close();
                } else {
                    mySessionWrapper.commitTransaction();
                }
            }
        }
    }

    protected void saveResource(Map<?, ?> options) {
        log.debug((Object)("Saving resource with uri: " + this.getURI()));
        boolean err = true;
        SessionWrapper mySessionWrapper = this.getSessionWrapper();
        try {
            try {
                if (!this.hasSessionController) {
                    mySessionWrapper.beginTransaction();
                }
                for (EObject eobject : super.getContents()) {
                    mySessionWrapper.saveOrUpdate(eobject);
                }
                for (Object obj : this.removedEObjects) {
                    InternalEObject eobj = (InternalEObject)obj;
                    if (eobj.eResource() != null && eobj.eResource() != this || IdentifierUtil.getID(obj, (SessionImplementor)mySessionWrapper.getHibernateSession()) == null || eobj.eDirectResource() != null && eobj.eDirectResource() != this) continue;
                    mySessionWrapper.delete(obj);
                    EMFInterceptor.registerCollectionsForDereferencing((EObject)obj);
                }
                if (!this.hasSessionController) {
                    mySessionWrapper.flush();
                }
                err = false;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new HbMapperException("Exception when saving resource " + this.emfDataStore.getName(), (Throwable)e);
            }
        }
        finally {
            if (!this.hasSessionController) {
                if (err) {
                    mySessionWrapper.rollbackTransaction();
                } else {
                    mySessionWrapper.commitTransaction();
                }
            }
        }
    }

    protected List<EObject> loadResource(Map<?, ?> options) {
        log.debug((Object)("Loading resource: " + this.getURI().toString()));
        boolean err = true;
        SessionWrapper mySessionWrapper = this.getSessionWrapper();
        try {
            if (!this.hasSessionController) {
                mySessionWrapper.beginTransaction();
            }
            List<EObject> storeList = this.loadFromStore(mySessionWrapper);
            log.debug((Object)("Loaded " + storeList.size() + " objects"));
            err = false;
            List<EObject> list = storeList;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new HbMapperException("Exception when saving resource " + this.emfDataStore.getName(), (Throwable)e);
        }
        finally {
            if (!this.hasSessionController) {
                if (err) {
                    mySessionWrapper.rollbackTransaction();
                    mySessionWrapper.close();
                } else {
                    mySessionWrapper.commitTransaction();
                }
            }
        }
    }

    protected void doUnload() {
        super.doUnload();
        if (!this.hasSessionController) {
            if (!this.getSessionWrapper().isEJB3EntityManager()) {
                AssertUtil.assertTrue((String)"Session must be disconnected in unload", (!((SessionImpl)this.getSessionWrapper().getSession()).isTransactionInProgress() ? 1 : 0) != 0);
            }
            log.debug((Object)"Doing unload, closing and nullifying session");
            this.getSessionWrapper().close();
            this.setSessionWrapper(null);
        } else {
            log.debug((Object)"Doing unload, has session controller, sessioncontroller is therefor responsible for session close");
        }
    }

    protected List<EObject> loadFromStore(SessionWrapper sess) {
        if (this.definedQueriesPresent()) {
            return this.loadUsingDefinedQueries(sess);
        }
        return this.loadUsingTopClasses(sess);
    }

    private ArrayList<EObject> loadUsingTopClasses(SessionWrapper sess) {
        log.debug((Object)("Loading resource " + this.getURI() + " using top classes"));
        ArrayList<EObject> readObjects = new ArrayList<EObject>();
        String[] stringArray = this.topClassNames;
        int n = this.topClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String topClassName = stringArray[n2];
            log.debug((Object)("Loading objects using hql: FROM " + topClassName));
            List<?> qryResult = sess.isEJB3EntityManager() ? sess.executeQuery("select o from " + topClassName + " o") : sess.executeQuery("from " + topClassName);
            for (EObject eobj : qryResult) {
                if (eobj.eContainer() != null) continue;
                readObjects.add(eobj);
            }
            ++n2;
        }
        return readObjects;
    }

    private ArrayList<EObject> loadUsingDefinedQueries(SessionWrapper sess) {
        String[] qrys;
        log.debug((Object)("Loading resource " + this.getURI() + " using defined queries"));
        ArrayList<EObject> readObjects = new ArrayList<EObject>();
        String[] stringArray = qrys = this.getDefinedQueries();
        int n = qrys.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            List<?> qryResult = sess.executeQuery(element);
            log.debug((Object)("Loading objects using hql: " + element));
            for (Object obj : qryResult) {
                readObjects.add((EObject)obj);
            }
            ++n2;
        }
        return readObjects;
    }

    public Object[] getObjectsByQuery(String query, boolean cache) {
        log.debug((Object)("Started listing objects by query " + query + " in resource " + this.getURI()));
        SessionWrapper mySessionWrapper = null;
        boolean err = true;
        this.setIsLoading(true);
        try {
            mySessionWrapper = this.getSessionWrapper();
            if (!this.hasSessionController) {
                mySessionWrapper.beginTransaction();
            }
            List<?> qryResult = mySessionWrapper.executeQuery(query, cache);
            for (Object object : qryResult) {
                if (!(object instanceof InternalEObject)) continue;
                InternalEObject eObject = (InternalEObject)object;
                assert (eObject.eResource() != this || this.loadedEObjectSet.contains(eObject) || this.newEObjects.contains(eObject));
                this.addToContent(eObject);
            }
            err = false;
            log.debug((Object)("Listed " + qryResult.size() + " objects using query " + query + " in resource " + this.getURI()));
            Object[] objectArray = qryResult.toArray();
            return objectArray;
        }
        finally {
            if (!this.hasSessionController) {
                if (err) {
                    mySessionWrapper.rollbackTransaction();
                    mySessionWrapper.close();
                } else {
                    mySessionWrapper.commitTransaction();
                }
            }
            this.setIsLoading(false);
            log.debug((Object)("Finished getting objects by query " + query + " in resource " + this.getURI()));
        }
    }

    public boolean isHasSessionController() {
        return this.hasSessionController;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public Object[] listByQuery(String query, boolean cache) {
        log.debug((Object)("Started listing objects by query " + query + " in resource " + this.getURI()));
        SessionWrapper mySessionWrapper = null;
        boolean err = true;
        this.setIsLoading(true);
        Notification notification = this.setLoaded(true);
        try {
            mySessionWrapper = this.getSessionWrapper();
            if (!this.hasSessionController) {
                mySessionWrapper.beginTransaction();
            }
            List<?> qryResult = mySessionWrapper.executeQuery(query, cache);
            for (Object object : qryResult) {
                if (!(object instanceof InternalEObject)) continue;
                this.addToContent((InternalEObject)object);
            }
            err = false;
            log.debug((Object)("Listed " + qryResult.size() + " objects using query " + query + " in resource " + this.getURI()));
            Object[] objectArray = qryResult.toArray();
            return objectArray;
        }
        finally {
            this.setIsLoading(false);
            if (!this.hasSessionController) {
                if (err) {
                    mySessionWrapper.rollbackTransaction();
                    mySessionWrapper.close();
                } else {
                    mySessionWrapper.commitTransaction();
                }
            }
            if (notification != null) {
                this.eNotify(notification);
            }
            log.debug((Object)("Finished listing objects by query " + query + " in resource " + this.getURI()));
        }
    }
}

