/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.jpox.elist.GenericFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.mapper.JPOXMappingException;
import org.eclipse.emf.teneo.jpox.mapper.MappingContext;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeEObject;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeObject;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingUtil {
    protected static final Log log = LogFactory.getLog(MappingUtil.class);

    public static String getImplNameOfEClass(String eClassURI, MappingContext mappingContext) {
        EClass eclass = mappingContext.getEntityNameStrategy().toEClass(eClassURI);
        if (eclass == null) {
            throw new JPOXMappingException("Uri: " + eClassURI + " does not translate to an eclass");
        }
        Class<?> clazz = MappingUtil.getImplClassOfEClass(eclass);
        if (clazz == null) {
            throw new JPOXMappingException("Uri: " + eClassURI + " does not translate to an instance class");
        }
        return clazz.getName();
    }

    public static Class<?> getImplClassOfEClass(EClass eClass) {
        if (eClass.isInterface()) {
            return eClass.getInstanceClass();
        }
        return EModelResolver.instance().getJavaClass((EClassifier)eClass);
    }

    public static void addAnytypeMapping(Element field) {
        Element embeddedElement = field.addElement("element").addElement("embedded");
        Element fieldElement = embeddedElement.addElement("field");
        fieldElement.addAttribute("name", "classifier");
        fieldElement.addElement("column").addAttribute("name", "CLASSIFIER");
        fieldElement = embeddedElement.addElement("field");
        fieldElement.addAttribute("name", "value");
        fieldElement.addElement("column").addAttribute("name", "VALUE");
    }

    public static void addFeatureMapEntryMapping(Element field) {
        log.debug((Object)"Any feature entry, adding embedded tags");
        Element embeddedElement = field.addElement("element").addElement("embedded");
        Element fieldElement = embeddedElement.addElement("field");
        fieldElement.addAttribute("name", "featurePath");
        fieldElement.addElement("column").addAttribute("name", "FEATUREPATH");
        fieldElement = embeddedElement.addElement("field");
        fieldElement.addAttribute("name", "anyValue");
        fieldElement.addElement("column").addAttribute("name", "ANYVALUE");
    }

    public static void addGenericFeatureMapEntryMapping(Element field, PAnnotatedEAttribute aAttribute, FetchType ft) {
        EAttribute eAttribute = aAttribute.getModelEAttribute();
        log.debug((Object)"Any feature entry, adding embedded tags");
        Element collection = field.addElement("collection").addAttribute("element-type", GenericFeatureMapEntry.class.getName());
        field.addElement("join");
        Element embeddedElement = field.addElement("element").addElement("embedded");
        Element fieldElement = embeddedElement.addElement("field").addAttribute("name", "featurePath");
        fieldElement = embeddedElement.addElement("field").addAttribute("name", "localAnyValue").addAttribute("embedded", "true");
        MappingUtil.addExtensionImplementationClasses(fieldElement, false, false, eAttribute);
        fieldElement = embeddedElement.addElement("field").addAttribute("name", "localReferenceValue");
        if (!MappingUtil.addExtensionImplementationClasses(fieldElement, true, false, eAttribute)) {
            fieldElement.addAttribute("embedded", "true");
        }
        fieldElement.addElement("foreign-key").addAttribute("delete-action", "restrict").addAttribute("update-action", "cascade");
        fieldElement = embeddedElement.addElement("field");
        fieldElement.addAttribute("name", "localContainmentReferenceValue").addAttribute("dependent", "true");
        fieldElement.addElement("foreign-key").addAttribute("delete-action", "cascade").addAttribute("update-action", "cascade");
        if (!MappingUtil.addExtensionImplementationClasses(fieldElement, true, true, eAttribute)) {
            fieldElement.addAttribute("embedded", "true");
        }
        MappingUtil.addEagerLazyLoading(collection, ft);
    }

    public static void addEagerLazyLoading(Element field, FetchType ft) {
        if (ft.equals((Object)FetchType.EAGER)) {
            field.addElement("extension").addAttribute("vendor-name", "jpox").addAttribute("key", "cache-lazy-loading").addAttribute("value", "false");
        } else {
            field.addElement("extension").addAttribute("vendor-name", "jpox").addAttribute("key", "cache-lazy-loading").addAttribute("value", "true");
            if (ft.equals((Object)FetchType.EXTRA)) {
                field.addElement("extension").addAttribute("vendor-name", "jpox").addAttribute("key", "cache").addAttribute("value", "false");
            }
        }
    }

    public static boolean isWildcard(EStructuralFeature eStructuralFeature) {
        return StoreUtil.isWildCard((EStructuralFeature)eStructuralFeature);
    }

    public static boolean isGroup(EStructuralFeature eStructuralFeature) {
        return StoreUtil.isGroupFeature((EStructuralFeature)eStructuralFeature);
    }

    private static boolean addExtensionImplementationClasses(Element element, boolean onlyEObject, boolean containment, EAttribute eattr) {
        boolean foundImpl;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<EStructuralFeature> featureResult = new ArrayList<EStructuralFeature>();
        for (Object element2 : eattr.getEContainingClass().getEStructuralFeatures()) {
            Class implClass;
            EStructuralFeature efeature = (EStructuralFeature)element2;
            if (containment && efeature instanceof EReference && !((EReference)efeature).isContainment() || !containment && onlyEObject && efeature instanceof EReference && ((EReference)efeature).isContainment() || !StoreUtil.isElementOfGroup((EStructuralFeature)efeature, (EStructuralFeature)eattr)) continue;
            Class instanceClass = efeature.getEType().getInstanceClass();
            if (!onlyEObject && !EObject.class.isAssignableFrom(instanceClass) && !String.class.isAssignableFrom(instanceClass) && efeature instanceof EAttribute) {
                if (result.contains(instanceClass.getName())) continue;
                String name = instanceClass.getName();
                if (name.indexOf(46) == -1) {
                    log.warn((Object)("Primitive type " + name + " prepending java.lang."));
                    name = "java.lang." + name.substring(0, 1).toUpperCase() + name.substring(1);
                }
                result.add(name);
                featureResult.add(efeature);
                continue;
            }
            if (!onlyEObject || !(efeature instanceof EReference) || (implClass = EModelResolver.instance().getJavaClass((EClassifier)((EReference)efeature).getEReferenceType())) == null || result.contains(implClass.getName())) continue;
            result.add(implClass.getName());
            featureResult.add(efeature);
        }
        String[] implClasses = result.toArray(new String[result.size()]);
        EStructuralFeature[] features = featureResult.toArray(new EStructuralFeature[featureResult.size()]);
        StringBuffer resultStr = new StringBuffer();
        StringBuffer fResultStr = new StringBuffer();
        boolean bl = foundImpl = implClasses.length > 0;
        if (implClasses.length > 0) {
            int i = 0;
            while (i < implClasses.length) {
                if (resultStr.length() > 0) {
                    resultStr.append(",");
                    fResultStr.append(",");
                }
                resultStr.append(implClasses[i]);
                fResultStr.append(features[i].getName());
                ++i;
            }
        } else if (onlyEObject) {
            resultStr.append(AnyTypeEObject.class.getName());
        } else {
            resultStr.append(AnyTypeObject.class.getName());
        }
        element.addElement("extension").addAttribute("vendor-name", "jpox").addAttribute("key", "implementation-classes").addAttribute("value", resultStr.toString());
        element.addElement("extension").addAttribute("vendor-name", "teneo").addAttribute("key", "estructuralfeatures").addAttribute("value", fResultStr.toString());
        return foundImpl;
    }
}

