/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.elist;

import javax.jdo.spi.PersistenceCapable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;
import org.eclipse.emf.teneo.jpox.elist.AnyFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.mapping.JPOXSimpleAnyTypeImpl;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.PersistenceManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.OID;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.SingleFieldMultiMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyFeatureMapEntryMapping
extends SingleFieldMultiMapping {
    private static Log log = LogFactory.getLog(AnyFeatureMapEntryMapping.class);
    private static final String IS_EOBJECT = "eobject";
    private static final String IS_NOT_EOBJECT = "not_eobject";

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
        this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
        this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
    }

    public Class<?> getJavaType() {
        return EObject.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return new AnyFeatureMapEntry((EStructuralFeature)XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text(), (Object)"sample value");
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return null;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return null;
    }

    public void setObject(PersistenceManager pm, Object preparedStatement, int[] exprIndex, Object value) {
        AnyFeatureMapEntry entry = (AnyFeatureMapEntry)value;
        EStructuralFeature feature = entry.getEStructuralFeature();
        Object entryValue = entry.getValue();
        String setValue = null;
        String setDiscriminator = null;
        if (entryValue instanceof EObject) {
            if (!(entryValue instanceof PersistenceCapable)) {
                throw new JpoxStoreException("Only persistencecapable EObjects can be stored in an any element, the class: " + entryValue.getClass().getName() + " is not persistencecapable. " + " Make sure that this class is enhanced!");
            }
            PersistenceCapable pc = (PersistenceCapable)entryValue;
            if (pc.jdoGetObjectId() == null) {
                pm.makePersistent((Object)pc);
            }
            setValue = pc.jdoGetObjectId().toString();
            setDiscriminator = IS_EOBJECT;
        } else {
            JPOXSimpleAnyTypeImpl simpleType = new JPOXSimpleAnyTypeImpl();
            simpleType.setInstanceType((EDataType)feature.getEType());
            simpleType.setValue(entryValue);
            setValue = simpleType.getRawValue();
            setDiscriminator = IS_NOT_EOBJECT;
        }
        this.getDataStoreMapping(0).setString(preparedStatement, exprIndex[0], StoreUtil.structuralFeatureToString((EStructuralFeature)feature));
        this.getDataStoreMapping(1).setString(preparedStatement, exprIndex[1], setValue);
        this.getDataStoreMapping(2).setString(preparedStatement, exprIndex[2], setDiscriminator);
    }

    public Object getObject(PersistenceManager pm, Object resultSet, int[] exprIndex) {
        String strFeature = this.getDataStoreMapping(0).getString(resultSet, exprIndex[0]);
        String strValue = this.getDataStoreMapping(1).getString(resultSet, exprIndex[1]);
        String strDiscriminator = this.getDataStoreMapping(2).getString(resultSet, exprIndex[2]);
        EStructuralFeature feature = StoreUtil.stringToStructureFeature((String)strFeature);
        if (strDiscriminator.compareTo(IS_EOBJECT) == 0) {
            Object obj = pm.getObjectById((Object)new OID(strValue), true, true, null);
            if (obj == null) {
                String msg = "EObjectMapping.getObject(): Object with object id: " + strValue + " of feature: " + strFeature + " can not be retrieved, is has probably been deleted!";
                log.error((Object)msg);
                return new AnyFeatureMapEntry(feature, null);
            }
            return obj;
        }
        JPOXSimpleAnyTypeImpl anyTypeImpl = new JPOXSimpleAnyTypeImpl();
        anyTypeImpl.setInstanceType((EDataType)feature.getEType());
        anyTypeImpl.setRawValue(strValue);
        return new AnyFeatureMapEntry(feature, anyTypeImpl.getValue());
    }
}

