/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyFoundEvent;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyGraphUpdater;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolvedEvent;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceRemovedEvent;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DependencyGraphUpdaterTest {
    Graph<String> graph;
    DependencyGraphUpdater<String> sut;

    @Before
    public void setUp() {
        this.graph = (Graph)Mockito.mock(Graph.class);
        this.sut = new DependencyGraphUpdater(this.graph, new EventBus());
    }

    @Test(expected=NullPointerException.class)
    public void testInstantiationWithNullGraph() {
        new DependencyGraphUpdater(null, new EventBus());
    }

    @Test(expected=NullPointerException.class)
    public void testInstantiationWithNullEventBus() {
        new DependencyGraphUpdater((IGraph)new Graph(), null);
    }

    @Test
    public void testInstantiationWithoutException() {
        new DependencyGraphUpdater((IGraph)new Graph(), new EventBus());
    }

    @Test
    public void testInstantiationDoesNotModifyGraph() {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.graph});
    }

    @Test
    public void testRecordNodeAddsNodeToGraph() {
        ResolvedEvent event1 = new ResolvedEvent((Object)"1");
        this.sut.recordNode(event1);
        ResolvedEvent event2 = new ResolvedEvent((Object)"2");
        this.sut.recordNode(event2);
        ((Graph)Mockito.verify(this.graph)).add((Object)((String)event1.getNode()));
        ((Graph)Mockito.verify(this.graph)).add((Object)((String)event2.getNode()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.graph});
    }

    @Test
    public void testRecordEdgeWithoutParent() {
        DependencyFoundEvent event1 = new DependencyFoundEvent((Object)"from1", (Object)"to1");
        this.sut.recordEdge(event1);
        DependencyFoundEvent event2 = new DependencyFoundEvent((Object)"from2", (Object)"to2");
        this.sut.recordEdge(event2);
        ((Graph)Mockito.verify(this.graph)).addChildren((Object)((String)event1.getFrom()), Collections.singleton((String)event1.getTo()));
        ((Graph)Mockito.verify(this.graph)).addChildren((Object)((String)event2.getFrom()), Collections.singleton((String)event2.getTo()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.graph});
    }

    @Test
    public void testRecordEdgeWithParent() {
        DependencyFoundEvent event1 = new DependencyFoundEvent((Object)"from1", (Object)"to1", Optional.of((Object)"parent"));
        this.sut.recordEdge(event1);
        ((Graph)Mockito.verify(this.graph)).addChildren((Object)((String)event1.getFrom()), Collections.singleton((String)event1.getTo()));
        ((Graph)Mockito.verify(this.graph)).addParentData((Object)((String)event1.getTo()), (Object)((String)event1.getParent().get()));
        DependencyFoundEvent event2 = new DependencyFoundEvent((Object)"from2", (Object)"to2", Optional.of((Object)"parent2"));
        this.sut.recordEdge(event2);
        ((Graph)Mockito.verify(this.graph)).addChildren((Object)((String)event2.getFrom()), Collections.singleton((String)event2.getTo()));
        ((Graph)Mockito.verify(this.graph)).addParentData((Object)((String)event2.getTo()), (Object)((String)event2.getParent().get()));
    }

    @Test
    public void testRemoval() {
        this.sut.recordNode(new ResolvedEvent((Object)"a"));
        this.sut.recordNode(new ResolvedEvent((Object)"b"));
        this.sut.recordNode(new ResolvedEvent((Object)"c"));
        this.sut.recordNode(new ResolvedEvent((Object)"d"));
        ResourceRemovedEvent event = new ResourceRemovedEvent((Set)Sets.newHashSet((Object[])new String[]{"a", "b", "c"}));
        this.sut.recordRemoval(event);
        ((Graph)Mockito.verify(this.graph, (VerificationMode)Mockito.times((int)4))).add((Object)ArgumentMatchers.anyString());
        ((Graph)Mockito.verify(this.graph)).removeAll((Collection)event.getElements());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.graph});
    }
}

