/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class DanglingReferenceAfterMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final BatchMerger batchMerger = new BatchMerger(IMerger.RegistryImpl.createStandaloneInstance());

    @Test
    public void testDanglingReferencePostMergeLtR() throws IOException {
        Resource ancestor = this.input.getDanglingPostMergeAncestor();
        Resource left = this.input.getDanglingPostMergeLeft();
        Resource right = this.input.getDanglingPostMergeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff changedReference = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.container.ClassA", (String)"singleValuedReference", (String)"root.referencedContainer.ClassB", (String)"root.referencedContainer.ClassC")));
        Diff addedClassC = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), this.addedToSingleValuedReference("root.referencedContainer", "singleValueContainment", "root.referencedContainer.ClassC")));
        Diff removedClassB = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), this.removedFromSingleValuedReference("root.referencedContainer", "singleValueContainment", "root.referencedContainer.ClassB")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(addedClassC), (Monitor)new BasicMonitor());
        this.assertNoDangling(right);
        Assert.assertNotNull((Object)this.getNodeNamed(right, "ClassB"));
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)changedReference.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)addedClassC.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)removedClassB.getState());
    }

    @Test
    public void testDanglingReferencePostMergeRtL() throws IOException {
        Resource ancestor = this.input.getDanglingPostMergeAncestor();
        Resource left = this.input.getDanglingPostMergeLeft();
        Resource right = this.input.getDanglingPostMergeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff changedReference = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.changedReference((String)"root.container.ClassA", (String)"singleValuedReference", (String)"root.referencedContainer.ClassB", (String)"root.referencedContainer.ClassC")));
        Diff addedClassC = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), this.addedToSingleValuedReference("root.referencedContainer", "singleValueContainment", "root.referencedContainer.ClassC")));
        Diff removedClassB = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), this.removedFromSingleValuedReference("root.referencedContainer", "singleValueContainment", "root.referencedContainer.ClassB")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(addedClassC), (Monitor)new BasicMonitor());
        this.assertNoDangling(left);
        Assert.assertNotNull((Object)this.getNodeNamed(left, "ClassC"));
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)changedReference.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)addedClassC.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)removedClassB.getState());
    }

    private void assertNoDangling(Resource res) {
        TreeIterator iterator = res.getAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            for (EObject o : next.eCrossReferences()) {
                Assert.assertNotNull((Object)o.eResource());
            }
        }
    }

    private Predicate<? super Diff> addedToSingleValuedReference(String qualifiedName, String referenceName, String addedQualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.referenceValueMatch((String)referenceName, (String)addedQualifiedName, (boolean)false)});
    }

    private Predicate<? super Diff> removedFromSingleValuedReference(String qualifiedName, String referenceName, String addedQualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.referenceValueMatch((String)referenceName, (String)addedQualifiedName, (boolean)false)});
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

