/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.rcp;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mat.ui.rcp.Messages;
import org.eclipse.mat.ui.rcp.RCPPlugin;
import org.eclipse.mat.ui.rcp.actions.AddHistoryToMenuAction;
import org.eclipse.mat.ui.rcp.actions.OpenHelp;
import org.eclipse.mat.ui.rcp.actions.OpenPreferenceAction;
import org.eclipse.mat.ui.rcp.actions.ShowViewMenu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction helpAction;
    private ActionFactory.IWorkbenchAction welcomeAction;
    private Action preferencesAction;
    private IContributionItem openViewAction;
    private IContributionItem historyAction;
    private ActionFactory.IWorkbenchAction aboutAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.helpAction = new OpenHelp();
        this.register((IAction)this.helpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        if (window.getWorkbench().getIntroManager().hasIntro()) {
            this.welcomeAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.welcomeAction);
        } else {
            RCPPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.mat.ui.rcp", Messages.ApplicationActionBarAdvisor_NotRunningAsAProduct));
        }
        this.preferencesAction = new OpenPreferenceAction();
        this.openViewAction = new ShowViewMenu(window);
        this.historyAction = new AddHistoryToMenuAction(window);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_File, "file");
        fileMenu.add((IContributionItem)new Separator("additions"));
        fileMenu.add(this.historyAction);
        fileMenu.add((IContributionItem)new GroupMarker("mru"));
        fileMenu.add((IAction)this.exitAction);
        menuBar.add((IContributionItem)fileMenu);
        MenuManager editMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Edit, "edit");
        editMenu.add((IContributionItem)new Separator("additions"));
        editMenu.add((IAction)this.copyAction);
        menuBar.add((IContributionItem)editMenu);
        MenuManager windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Window, "window");
        windowMenu.add(this.openViewAction);
        windowMenu.add((IContributionItem)new Separator("additions"));
        windowMenu.add((IAction)this.preferencesAction);
        menuBar.add((IContributionItem)windowMenu);
        MenuManager helpMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Help, "help");
        helpMenu.add((IContributionItem)new Separator("group.help"));
        if (this.welcomeAction != null) {
            helpMenu.add((IAction)this.welcomeAction);
        }
        helpMenu.add((IAction)this.helpAction);
        helpMenu.add((IContributionItem)new Separator("additions"));
        helpMenu.add((IContributionItem)new Separator(ActionFactory.ABOUT.getId()));
        helpMenu.add((IAction)this.aboutAction);
        menuBar.add((IContributionItem)helpMenu);
        menuBar.add((IContributionItem)new Separator("additions"));
    }
}

