/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.PseudoReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;

public class InstanceImpl
extends AbstractObjectImpl
implements IInstance {
    private static final long serialVersionUID = 1L;
    private volatile List<Field> fields;
    private volatile Map<String, Field> name2field;

    public InstanceImpl(int objectId, long address, ClassImpl clazz, List<Field> fields) {
        super(objectId, address, clazz);
        this.fields = fields;
    }

    @Override
    public long getObjectAddress() {
        try {
            long address = super.getObjectAddress();
            if (address == Long.MIN_VALUE) {
                address = this.source.mapIdToAddress(this.getObjectId());
                this.setObjectAddress(address);
            }
            return address;
        }
        catch (SnapshotException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getObjectId() {
        try {
            int objectId = super.getObjectId();
            if (objectId < 0) {
                objectId = this.source.mapAddressToId(this.getObjectAddress());
                this.setObjectId(objectId);
            }
            return objectId;
        }
        catch (SnapshotException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.readFully();
        }
        return this.fields;
    }

    public Field getField(String name) {
        return this.internalGetField(name);
    }

    protected void setFields(List<Field> fields) {
        this.fields = fields;
    }

    protected synchronized void readFully() {
        if (this.fields != null) {
            return;
        }
        try {
            int objectId = this.getObjectId();
            InstanceImpl fullCopy = (InstanceImpl)this.source.getHeapObjectReader().read(objectId, this.source);
            this.setObjectAddress(fullCopy.getObjectAddress());
            this.fields = fullCopy.fields;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (SnapshotException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long getUsedHeapSize() {
        try {
            int objId;
            try {
                objId = this.getObjectId();
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SnapshotException) {
                    throw (SnapshotException)cause;
                }
                throw e;
            }
            return this.getSnapshot().getHeapSize(objId);
        }
        catch (SnapshotException e) {
            return this.classInstance.getHeapSizePerInstance();
        }
    }

    @Override
    public ArrayLong getReferences() {
        HashMapIntObject localVars;
        List<Field> fields = this.getFields();
        ArrayLong list = new ArrayLong(fields.size() + 1);
        list.add(this.classInstance.getObjectAddress());
        HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> threadToLocalVars = this.source.getRootsPerThread();
        if (threadToLocalVars != null && (localVars = (HashMapIntObject)threadToLocalVars.get(this.getObjectId())) != null) {
            IteratorInt localsIds = localVars.keys();
            while (localsIds.hasNext()) {
                int localId = localsIds.next();
                GCRootInfo[] rootInfo = (GCRootInfo[])localVars.get(localId);
                list.add(rootInfo[0].getObjectAddress());
            }
        }
        for (Field field : fields) {
            if (!(field.getValue() instanceof ObjectReference)) continue;
            ObjectReference ref = (ObjectReference)field.getValue();
            list.add(ref.getObjectAddress());
        }
        return list;
    }

    public List<NamedReference> getOutboundReferences() {
        ArrayList<NamedReference> list = new ArrayList<NamedReference>();
        list.add((NamedReference)new PseudoReference((ISnapshot)this.source, this.classInstance.getObjectAddress(), "<class>"));
        HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> threadToLocalVars = this.source.getRootsPerThread();
        if (threadToLocalVars != null) {
            HashMapIntObject localVars;
            try {
                localVars = (HashMapIntObject)threadToLocalVars.get(this.getObjectId());
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SnapshotException) {
                    localVars = null;
                }
                throw e;
            }
            if (localVars != null) {
                IteratorInt localsIds = localVars.keys();
                while (localsIds.hasNext()) {
                    int localId = localsIds.next();
                    GCRootInfo[] rootInfo = (GCRootInfo[])localVars.get(localId);
                    ThreadToLocalReference ref = new ThreadToLocalReference((ISnapshot)this.source, rootInfo[0].getObjectAddress(), "<" + GCRootInfo.getTypeSetAsString((GCRootInfo[])rootInfo) + ">", localId, rootInfo);
                    list.add((NamedReference)ref);
                }
            }
        }
        for (Field field : this.getFields()) {
            if (!(field.getValue() instanceof ObjectReference)) continue;
            ObjectReference ref = (ObjectReference)field.getValue();
            list.add(new NamedReference((ISnapshot)this.source, ref.getObjectAddress(), field.getName()));
        }
        return list;
    }

    @Override
    protected Field internalGetField(String name) {
        if (this.name2field == null) {
            List<Field> fields = this.getFields();
            HashMap<String, Field> n2f = new HashMap<String, Field>(fields.size());
            for (Field f : fields) {
                n2f.put(f.getName(), f);
            }
            this.name2field = n2f;
        }
        return this.name2field.get(name);
    }
}

