/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.debug.debugmodel;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.IValueVariableListener;
import org.eclipse.lsp4e.debug.debugmodel.JsonParserWithStringSubstitution;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonParserWithStringSubstitutionTest
extends AbstractTest {
    @Test
    public void testThrowsIllegaStateException() throws IllegalStateException, CoreException {
        String json = "[\"value1\", \"value2\", \"value3\"]";
        JsonParserWithStringSubstitution jsonParser = new JsonParserWithStringSubstitution((IStringVariableManager)new StringVariableManagerMock());
        Assertions.assertThrows(IllegalStateException.class, () -> {
            Map map = jsonParser.parseJsonObject("[\"value1\", \"value2\", \"value3\"]");
        });
    }

    @Test
    public void testThrowsCoreException() throws IllegalStateException, CoreException {
        String json = "{\"key\":\"unknown_variable\"}";
        StringVariableManagerMock stringVariableManager = new StringVariableManagerMock("Test", "Test");
        JsonParserWithStringSubstitution jsonParser = new JsonParserWithStringSubstitution((IStringVariableManager)stringVariableManager);
        Assertions.assertThrows(CoreException.class, () -> {
            Map map = jsonParser.parseJsonObject("{\"key\":\"unknown_variable\"}");
        });
    }

    @Test
    public void testSubstituteVariableInJsonObject() throws IllegalStateException, CoreException {
        String key = "key";
        String variableReference = "variableReference";
        String variableReplacement = "variableReplacement";
        String json = "{\"key\":\"variableReference\"}";
        StringVariableManagerMock stringVariableManager = new StringVariableManagerMock("variableReference", "variableReplacement");
        JsonParserWithStringSubstitution jsonParser = new JsonParserWithStringSubstitution((IStringVariableManager)stringVariableManager);
        Map parsedJson = jsonParser.parseJsonObject("{\"key\":\"variableReference\"}");
        String resultValue = (String)parsedJson.get("key");
        Assertions.assertEquals((Object)"variableReplacement", (Object)resultValue);
    }

    @Test
    public void testSubstituteVariableInJsonObjectWithArray() throws IllegalStateException, CoreException {
        String key = "key";
        String variableReference = "variableReference";
        String variableReplacement = "variableReplacement";
        String json = "{\"key\":[\"variableReference\"]}";
        StringVariableManagerMock stringVariableManager = new StringVariableManagerMock("variableReference", "variableReplacement");
        JsonParserWithStringSubstitution jsonParser = new JsonParserWithStringSubstitution((IStringVariableManager)stringVariableManager);
        Map parsedJson = jsonParser.parseJsonObject("{\"key\":[\"variableReference\"]}");
        ArrayList resultArray = (ArrayList)parsedJson.get("key");
        String resultValue = (String)resultArray.get(0);
        Assertions.assertEquals((Object)"variableReplacement", (Object)resultValue);
    }

    @Test
    public void testSubstituteVariableInJsonObjectInJsonObject() throws IllegalStateException, CoreException {
        String key1 = "key1";
        String key2 = "key2";
        String variableReference = "variableReference";
        String variableReplacement = "variableReplacement";
        String json = "{\"key1\":{\"key2\":\"variableReference\"}}";
        StringVariableManagerMock stringVariableManager = new StringVariableManagerMock("variableReference", "variableReplacement");
        JsonParserWithStringSubstitution jsonParser = new JsonParserWithStringSubstitution((IStringVariableManager)stringVariableManager);
        Map parsedJson = jsonParser.parseJsonObject("{\"key1\":{\"key2\":\"variableReference\"}}");
        Map secondObject = (Map)parsedJson.get("key1");
        String resultValue = (String)secondObject.get("key2");
        Assertions.assertEquals((Object)"variableReplacement", (Object)resultValue);
    }

    private static final class StringVariableManagerMock
    implements IStringVariableManager {
        String variableReference = "";
        String variableReplacement = "";

        StringVariableManagerMock(String variableReference, String variableReplacement) {
            this.variableReference = variableReference;
            this.variableReplacement = variableReplacement;
        }

        StringVariableManagerMock() {
        }

        public IStringVariable[] getVariables() {
            throw new UnsupportedOperationException();
        }

        public IValueVariable[] getValueVariables() {
            throw new UnsupportedOperationException();
        }

        public IValueVariable getValueVariable(String name) {
            throw new UnsupportedOperationException();
        }

        public IDynamicVariable[] getDynamicVariables() {
            throw new UnsupportedOperationException();
        }

        public IDynamicVariable getDynamicVariable(String name) {
            throw new UnsupportedOperationException();
        }

        public String getContributingPluginId(IStringVariable variable) {
            throw new UnsupportedOperationException();
        }

        public String performStringSubstitution(String expression) throws CoreException {
            if (!expression.contains(this.variableReference)) {
                throw new CoreException(Status.error((String)"Unable to resolve variable"));
            }
            return expression.replace(this.variableReference, this.variableReplacement);
        }

        public String performStringSubstitution(String expression, boolean reportUndefinedVariables) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public void validateStringVariables(String expression) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public IValueVariable newValueVariable(String name, String description) {
            throw new UnsupportedOperationException();
        }

        public IValueVariable newValueVariable(String name, String description, boolean readOnly, String value) {
            throw new UnsupportedOperationException();
        }

        public void addVariables(IValueVariable[] variables) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public void removeVariables(IValueVariable[] variables) {
            throw new UnsupportedOperationException();
        }

        public void addValueVariableListener(IValueVariableListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeValueVariableListener(IValueVariableListener listener) {
            throw new UnsupportedOperationException();
        }

        public String generateVariableExpression(String varName, String arg) {
            throw new UnsupportedOperationException();
        }
    }
}

