/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package common.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;

import common.ImportContainer;

public class CommonUtil {
    private CommonUtil() {
        // no instantiation allowed
    }

    public static <T extends EObject> ArrayList<T> collect(final EObject container, Class<T> clazz) {
        var defs = new ArrayList<T>();
        collect(container, defs, clazz);
        return defs;
    }

    private static <T extends EObject> void collect(final EObject container, final List<T> defs, Class<T> clazz) {
        if (clazz.isInstance(container)) {
            defs.add(clazz.cast(container));
        }
        container.eContents().stream().forEach(o -> collect(o, defs, clazz));
        if (container instanceof ImportContainer importContainer) {
            for (var imp: importContainer.getImports()) {
                imp.load().forEach(o -> collect(o, defs, clazz));
            }
        }
    }
}
