/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.product.productdata;

public class ProductProperty {
    public enum WHEN {
        start, end
    }

    private transient Task task;

    public final WHEN at;

    public final String propertyName;

    public final Object propertyValue;

    public ProductProperty(Task action, WHEN at, String propertyName, Object propertyValue) {
        this.task = action;
        this.at = at;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    public Task getAction() {
        return task;
    }

    public void setAction(Task action) {
        this.task = action;
    }

    public WHEN getAt() {
        return at;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public Object getPropertyValue() {
        return propertyValue;
    }
}
