/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.activity.teditor.scoping;

import activity.Activity;
import activity.Event;
import activity.EventAction;
import activity.HasResourceAndItem;
import activity.LocationPrerequisite;
import activity.ModelTypeDefinitionRef;
import activity.PeripheralAction;
import activity.ProductChange;
import activity.impl.EventImpl;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import common.ImportContainer;
import common.ParameterDeclaration;
import common.TypeDefinition;
import common.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import machine.ActionType;
import machine.Distance;
import machine.IResource;
import machine.Machine;
import machine.Peripheral;
import machine.Profile;
import machine.Resource;
import machine.SymbolicPosition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import product.IProductDefinition;
import product.ProductDefinition;
import product.PropertyDefinition;

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it
 */
@SuppressWarnings("all")
public class ActivityScopeProvider extends AbstractDeclarativeScopeProvider {
  public IScope scope_ModelTypeDefinitionRef_typeDefinition(final ModelTypeDefinitionRef modelTypeDefinition, final EReference ref) {
    IScope _delegateGetScope = this.delegateGetScope(modelTypeDefinition, ref);
    final Predicate<IEObjectDescription> _function = (IEObjectDescription it) -> {
      return (((it.getEObjectOrProxy() instanceof Resource) && (!this.isEvent(it.getEObjectOrProxy()))) || (it.getEObjectOrProxy() instanceof ProductDefinition));
    };
    return new FilteringScope(_delegateGetScope, _function);
  }

  public IScope scope_HasResourceAndItem_resourceDefinition(final PeripheralAction action, final EReference ref) {
    IScope _delegateGetScope = this.delegateGetScope(action, ref);
    final Predicate<IEObjectDescription> _function = (IEObjectDescription it) -> {
      boolean _isEvent = this.isEvent(it.getEObjectOrProxy());
      return (!_isEvent);
    };
    return new FilteringScope(_delegateGetScope, _function);
  }

  public IScope scope_HasResourceAndItem_resourceDefinition(final EventAction action, final EReference ref) {
    IScope _delegateGetScope = this.delegateGetScope(action, ref);
    final Predicate<IEObjectDescription> _function = (IEObjectDescription it) -> {
      return this.isEvent(it.getEObjectOrProxy());
    };
    return new FilteringScope(_delegateGetScope, _function);
  }

  public IScope scope_IResource(final Activity activity, final EReference ref) {
    final Function1<ParameterDeclaration, EList<TypeDefinition>> _function = (ParameterDeclaration it) -> {
      return it.getDeclarations();
    };
    final Function1<IResource, Boolean> _function_1 = (IResource it) -> {
      Resource _resource = it.getResource();
      return Boolean.valueOf((_resource != null));
    };
    return Scopes.scopeFor(IterableExtensions.<IResource>filter(Iterables.<IResource>filter((Iterables.<ModelTypeDefinitionRef>filter(IterableExtensions.<ParameterDeclaration, TypeDefinition>flatMap(activity.getParameterDeclarations(), _function), ModelTypeDefinitionRef.class)), IResource.class), _function_1), this.delegateGetScope(activity, ref));
  }

  public IScope scope_IProductDefinition(final Activity activity, final EReference ref) {
    final Function1<ParameterDeclaration, EList<TypeDefinition>> _function = (ParameterDeclaration it) -> {
      return it.getDeclarations();
    };
    final Function1<IProductDefinition, Boolean> _function_1 = (IProductDefinition it) -> {
      EList<PropertyDefinition> _propertyDefinitions = it.getPropertyDefinitions();
      return Boolean.valueOf((_propertyDefinitions != null));
    };
    return Scopes.scopeFor(IterableExtensions.<IProductDefinition>filter(Iterables.<IProductDefinition>filter((Iterables.<ModelTypeDefinitionRef>filter(IterableExtensions.<ParameterDeclaration, TypeDefinition>flatMap(activity.getParameterDeclarations(), _function), ModelTypeDefinitionRef.class)), IProductDefinition.class), _function_1), this.delegateGetScope(activity, ref));
  }

  /**
   * Scoping for location prerequisites
   */
  public IScope scope_Peripheral(final LocationPrerequisite prerequisite, final EReference ref) {
    IResource _resource = prerequisite.getResource();
    boolean _tripleEquals = (null == _resource);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    final Function1<Peripheral, Boolean> _function = (Peripheral it) -> {
      boolean _isEmpty = it.getPositions().isEmpty();
      return Boolean.valueOf((!_isEmpty));
    };
    return Scopes.scopeFor(IterableExtensions.<Peripheral>filter(prerequisite.getResource().getResource().getPeripherals(), _function));
  }

  public IScope scope_SymbolicPosition(final LocationPrerequisite prerequisite, final EReference ref) {
    Peripheral _peripheral = prerequisite.getPeripheral();
    boolean _tripleEquals = (null == _peripheral);
    if (_tripleEquals) {
      return this.localScope(prerequisite, SymbolicPosition.class);
    }
    return Scopes.scopeFor(prerequisite.getPeripheral().getPositions(), this.localScope(prerequisite, SymbolicPosition.class));
  }

  /**
   * Scoping for node tree
   */
  public IScope scope_Node(final EditableDirectedGraph graph, final EReference ref) {
    EList<Node> _nodes = graph.getNodes();
    boolean _tripleEquals = (null == _nodes);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(graph.getNodes());
  }

  public IScope scope_Peripheral(final HasResourceAndItem context, final EReference ref) {
    IResource _resource = context.getResource();
    boolean _tripleEquals = (null == _resource);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(context.getResource().getResource().getPeripherals());
  }

  public IScope scope_ResourceItem(final HasResourceAndItem context, final EReference ref) {
    IResource _resourceDefinition = context.getResourceDefinition();
    boolean _tripleEquals = (null == _resourceDefinition);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(context.getResourceDefinition().getResource().getItems());
  }

  public IScope scope_ActionType(final PeripheralAction action, final EReference ref) {
    Peripheral _peripheral = action.getPeripheral();
    boolean _tripleEquals = (null == _peripheral);
    if (_tripleEquals) {
      return this.localScope(action, ActionType.class);
    }
    return Scopes.scopeFor(action.getPeripheral().getType().getActions(), this.localScope(action, ActionType.class));
  }

  public IScope scope_SymbolicPosition(final PeripheralAction action, final EReference ref) {
    Peripheral _peripheral = action.getPeripheral();
    boolean _tripleEquals = (null == _peripheral);
    if (_tripleEquals) {
      return this.localScope(action, SymbolicPosition.class);
    }
    return Scopes.scopeFor(action.getPeripheral().getPositions(), this.localScope(action, SymbolicPosition.class));
  }

  public IScope scope_Distance(final PeripheralAction action, final EReference ref) {
    Peripheral _peripheral = action.getPeripheral();
    boolean _tripleEquals = (null == _peripheral);
    if (_tripleEquals) {
      return this.localScope(action, Distance.class);
    }
    return Scopes.scopeFor(action.getPeripheral().getDistances(), this.localScope(action, Distance.class));
  }

  public IScope scope_Profile(final PeripheralAction action, final EReference ref) {
    Peripheral _peripheral = action.getPeripheral();
    boolean _tripleEquals = (null == _peripheral);
    if (_tripleEquals) {
      return this.localScope(action, Profile.class);
    }
    return Scopes.scopeFor(action.getPeripheral().getProfiles(), this.localScope(action, Profile.class));
  }

  public IScope scope_ResourceAction(final Activity activity, final EReference ref) {
    EList<Node> _nodes = activity.getNodes();
    boolean _tripleEquals = (null == _nodes);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(activity.getNodes());
  }

  public IScope scope_Property_definition(final ProductChange change, final EReference ref) {
    final ArrayList<Machine> machines = CommonUtil.<Machine>collect(EcoreUtil2.<ImportContainer>getContainerOfType(change, ImportContainer.class), Machine.class);
    final Function1<Machine, EList<ProductDefinition>> _function = (Machine it) -> {
      return it.getProductDefinitions();
    };
    final List<ProductDefinition> defs = IterableExtensions.<ProductDefinition>toList(IterableExtensions.<Machine, ProductDefinition>flatMap(machines, _function));
    int _size = defs.size();
    boolean _equals = (_size == 1);
    if (_equals) {
      return Scopes.scopeFor(defs.getFirst().getPropertyDefinitions());
    }
    IProductDefinition _product = change.getProduct();
    boolean _tripleEquals = (null == _product);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(change.getProduct().getPropertyDefinitions());
  }

  private IScope localScope(final EObject context, final Class<? extends EObject> clazz) {
    final List<? extends EObject> locals = this.localParameters(context, clazz);
    return Scopes.scopeFor(locals);
  }

  private <T extends Object> List<T> localParameters(final EObject context, final Class<T> clazz) {
    Activity _xifexpression = null;
    if ((context instanceof Activity)) {
      _xifexpression = ((Activity)context);
    } else {
      _xifexpression = EcoreUtil2.<Activity>getContainerOfType(context, Activity.class);
    }
    Activity activity = _xifexpression;
    if ((activity == null)) {
      return List.<T>of();
    }
    final Function1<ParameterDeclaration, EList<TypeDefinition>> _function = (ParameterDeclaration it) -> {
      return it.getDeclarations();
    };
    return IterableExtensions.<T>toList(Iterables.<T>filter(IterableExtensions.<ParameterDeclaration, TypeDefinition>flatMap(activity.getParameterDeclarations(), _function), clazz));
  }

  private boolean isEvent(final EObject eObject) {
    return ((eObject instanceof Event) || (eObject instanceof EventImpl));
  }
}
