/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;

public class FastContainsEList<E>
extends BasicEList<E> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final long serialVersionUID = 1L;
    private final Set<E> set;
    private transient Integer expectedModCount;

    public FastContainsEList() {
        this(16);
    }

    public FastContainsEList(int initialCapacity) {
        this(initialCapacity, new HashSet(initialCapacity));
    }

    protected FastContainsEList(int initialCapacity, Set<E> set) {
        super(initialCapacity);
        this.set = set;
    }

    public boolean contains(Object object) {
        if (this.expectedModCount == null || this.modCount != this.expectedModCount) {
            this.set.clear();
            this.set.addAll((Collection<E>)((Object)this));
            this.expectedModCount = this.modCount;
        }
        return this.set.contains(object);
    }

    public static class FastCompare<E>
    extends FastContainsEList<E> {
        private static final long serialVersionUID = 1L;

        public FastCompare() {
            this(16);
        }

        public FastCompare(int initialCapacity) {
            super(initialCapacity, Collections.newSetFromMap(new IdentityHashMap(initialCapacity)));
        }
    }
}

