/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.scheduler.algorithm;

import activity.PeripheralAction;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lsat_graph.DispatchGroupTask;
import lsat_graph.PeripheralActionTask;
import lsat_graph.ReleaseTask;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.scheduler.algorithm.ConstraintsUtil;
import org.eclipse.lsat.common.scheduler.algorithm.SchedulerException;
import org.eclipse.lsat.common.scheduler.graph.Constraint;
import org.eclipse.lsat.common.scheduler.graph.GraphFactory;
import org.eclipse.lsat.common.scheduler.graph.JitConstraint;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TimeConstraint;

public class BellmanFordImpl {
    private static final double ROUNDING_SCALE = 1.0E9;
    private static final GraphFactory GRAPH_FACTORY = GraphFactory.eINSTANCE;
    private final SchedulingType type;
    private Graph graph;
    private Task startNode;
    private Task endNode;

    public static <T extends Task> Map<Task, BigDecimal> schedule(Iterable<T> tasks, Iterable<Constraint> constraints) throws SchedulerException {
        BellmanFordImpl schedule1 = new BellmanFordImpl(SchedulingType.ASAP);
        Map<Task, Double> asapResults = schedule1.doSchedule(tasks, constraints);
        BellmanFordImpl schedule2 = new BellmanFordImpl(SchedulingType.ALAP);
        Map<Task, Double> alapResults = schedule2.doSchedule(tasks, constraints, asapResults);
        Double scheduleDuration = BellmanFordImpl.computeScheduleDuration(asapResults);
        HashMap<Task, BigDecimal> combinedResults = new HashMap<Task, BigDecimal>();
        for (Task task : tasks) {
            Double startTimeAsap = asapResults.get(task);
            double startTimeAlap = scheduleDuration - alapResults.get(task) - task.getExecutionTime().doubleValue();
            BigDecimal startTime = BigDecimal.valueOf(BellmanFordImpl.round(Math.max(startTimeAsap, startTimeAlap)));
            combinedResults.put(task, startTime);
        }
        return combinedResults;
    }

    private BellmanFordImpl(SchedulingType t) {
        this.type = t;
        this.graph = new Graph();
        this.startNode = GRAPH_FACTORY.createTask();
        this.startNode.setExecutionTime(BigDecimal.ZERO);
        this.graph.addVertex(this.startNode);
        this.endNode = GRAPH_FACTORY.createTask();
        this.endNode.setExecutionTime(BigDecimal.ZERO);
        this.graph.addVertex(this.endNode);
    }

    private <T extends Task> Map<Task, Double> doSchedule(Iterable<T> tasks, Iterable<Constraint> constraints) throws SchedulerException {
        return this.doSchedule(tasks, constraints, null);
    }

    private <T extends Task> Map<Task, Double> doSchedule(Iterable<T> tasks, Iterable<Constraint> constraints, Map<Task, Double> asapResults) throws SchedulerException {
        try {
            this.buildGraph(tasks, constraints);
            if (asapResults != null) {
                this.addAsapConstraints(tasks, asapResults);
            }
            return this.graph.schedule(this.type == SchedulingType.ASAP ? this.startNode : this.endNode);
        }
        catch (Graph.NegativeCycleDetectedException exception) {
            Set<Constraint> affectedConstraints = this.findAffectedConstraints(exception, constraints);
            Object errorMsg = "Could not compute a schedule due to invalid constraints:\n";
            errorMsg = (String)errorMsg + affectedConstraints.stream().map(c -> " - " + ConstraintsUtil.constraintToString(c)).collect(Collectors.joining("\n"));
            throw new SchedulerException((CharSequence)errorMsg, (Throwable)exception);
        }
    }

    private <T extends Task> void buildGraph(Iterable<T> tasks, Iterable<Constraint> constraints) throws Graph.NegativeCycleDetectedException {
        this.addTasks(tasks);
        this.addDependencies(tasks);
        this.addConstraintsForwardEdges(constraints);
        this.addConstraintsBackwardEdges(constraints);
    }

    private <T extends Task> void addAsapConstraints(Iterable<T> tasks, Map<Task, Double> asapResults) {
        Double duration = BellmanFordImpl.computeScheduleDuration(asapResults);
        this.addEdge(this.endNode, this.startNode, -duration.doubleValue());
        this.addEdge(this.startNode, this.endNode, duration);
        for (Task task : tasks) {
            if (BellmanFordImpl.supportsALAP(task)) continue;
            double weight = asapResults.get(task) + task.getExecutionTime().doubleValue();
            this.addEdge(task, this.startNode, -weight);
            this.addEdge(this.startNode, task, weight);
        }
    }

    private <T extends Task> void addTasks(Iterable<T> tasks) {
        for (Task task : tasks) {
            this.graph.addVertex(task);
        }
    }

    private <T extends Task> void addDependencies(Iterable<T> tasks) {
        for (Task task : tasks) {
            if (task.getIncomingEdges().isEmpty()) {
                if (this.type == SchedulingType.ASAP) {
                    this.addEdge(this.startNode, task, 0.0);
                } else {
                    this.addEdge(task, this.startNode, -task.getExecutionTime().doubleValue());
                }
            }
            if (task.getOutgoingEdges().isEmpty()) {
                if (this.type == SchedulingType.ASAP) {
                    this.addEdge(task, this.endNode, -task.getExecutionTime().doubleValue());
                } else {
                    this.addEdge(this.endNode, task, 0.0);
                }
            }
            if (this.type == SchedulingType.ASAP) {
                for (Edge edge : task.getOutgoingEdges()) {
                    this.addEdge(task, (Task)edge.getTargetNode(), -task.getExecutionTime().doubleValue());
                }
                continue;
            }
            for (Edge edge : task.getIncomingEdges()) {
                this.addEdge(task, (Task)edge.getSourceNode(), -task.getExecutionTime().doubleValue());
            }
        }
    }

    private void addConstraintsForwardEdges(Iterable<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            Task begin = this.type == SchedulingType.ASAP ? constraint.getSource() : constraint.getTarget();
            Task end = this.type == SchedulingType.ASAP ? constraint.getTarget() : constraint.getSource();
            BigDecimal weight = begin.getExecutionTime();
            if (constraint instanceof TimeConstraint) {
                TimeConstraint timeConstraint = (TimeConstraint)constraint;
                weight = weight.add(timeConstraint.getLowerBound());
            }
            this.addEdge(begin, end, -weight.doubleValue());
        }
    }

    private void addConstraintsBackwardEdges(Iterable<Constraint> constraints) {
        Task end;
        Task begin;
        HashMap<Constraint, BigDecimal> weights = new HashMap<Constraint, BigDecimal>();
        for (Constraint constraint : constraints) {
            begin = this.type == SchedulingType.ASAP ? constraint.getSource() : constraint.getTarget();
            end = this.type == SchedulingType.ASAP ? constraint.getTarget() : constraint.getSource();
            BigDecimal weight = BigDecimal.ZERO;
            if (constraint instanceof JitConstraint) {
                Double path = this.graph.shortestPath(begin).get(end);
                weight = new BigDecimal(-path.doubleValue());
            } else if (constraint instanceof TimeConstraint) {
                TimeConstraint timeConstraint = (TimeConstraint)constraint;
                weight = begin.getExecutionTime().add(timeConstraint.getUpperBound());
            }
            weights.put(constraint, weight);
        }
        for (Constraint constraint : constraints) {
            begin = this.type == SchedulingType.ASAP ? constraint.getSource() : constraint.getTarget();
            end = this.type == SchedulingType.ASAP ? constraint.getTarget() : constraint.getSource();
            this.addEdge(end, begin, ((BigDecimal)weights.get(constraint)).doubleValue());
        }
    }

    private void addEdge(Task begin, Task end, double weight) {
        this.graph.addEdge(begin, end, weight);
    }

    private Set<Constraint> findAffectedConstraints(Graph.NegativeCycleDetectedException exception, Iterable<Constraint> constraints) {
        List<Task> nodes = exception.getCycle();
        LinkedHashSet matchingConstraints = StreamSupport.stream(constraints.spliterator(), false).filter(c -> nodes.contains(c.getSource()) || nodes.contains(c.getTarget())).collect(Collectors.toCollection(LinkedHashSet::new));
        return matchingConstraints;
    }

    private static Double computeScheduleDuration(Map<Task, Double> results) {
        return results.values().stream().max(Double::compare).orElse(0.0);
    }

    private static <T extends Task> boolean supportsALAP(T task) {
        T t = task;
        Objects.requireNonNull(t);
        T t2 = t;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DispatchGroupTask.class, PeripheralActionTask.class, ReleaseTask.class}, t2, 0)) {
            case 0 -> {
                DispatchGroupTask ignored = (DispatchGroupTask)t2;
                yield false;
            }
            case 1 -> {
                PeripheralActionTask actionTask = (PeripheralActionTask)t2;
                yield ((PeripheralAction)actionTask.getAction()).scheduleAlap();
            }
            case 2 -> {
                ReleaseTask ignored = (ReleaseTask)t2;
                yield false;
            }
            default -> true;
        };
    }

    private static double round(double value) {
        return (double)Math.round(value * 1.0E9) / 1.0E9;
    }

    class Graph {
        private static final double EPSILON = 1.0E-9;
        private static final String GRAPH_CONTAINS_NEGATIVE_WEIGHT_CYCLE = "Graph contains a negative-weight cycle";
        private Map<Task, Integer> vertexToIndex = new HashMap<Task, Integer>();
        private List<Task> indexToVertex = new ArrayList<Task>();
        private List<List<Pair>> edges = new ArrayList<List<Pair>>();

        Graph() {
        }

        public void addVertex(Task task) {
            this.vertexToIndex.put(task, this.vertexToIndex.size());
            this.indexToVertex.add(task);
            this.edges.add(new ArrayList());
        }

        public void addEdge(Task frm, Task to, double weight) {
            int iFrm = this.vertexToIndex.get(frm);
            int iTo = this.vertexToIndex.get(to);
            this.edges.get(iFrm).add(new Pair(iTo, weight));
        }

        public Map<Task, Double> schedule(Task source) throws NegativeCycleDetectedException {
            return this.shortestPath(source, -1.0);
        }

        public Map<Task, Double> shortestPath(Task source) throws NegativeCycleDetectedException {
            return this.shortestPath(source, 1.0);
        }

        private Map<Task, Double> shortestPath(Task source, double scale) throws NegativeCycleDetectedException {
            double weight;
            int v;
            int u;
            int sourceIndex = this.vertexToIndex.get(source);
            int numVertices = this.vertexToIndex.size();
            double[] d = new double[numVertices];
            Arrays.fill(d, Double.MAX_VALUE);
            int[] pred = new int[numVertices];
            Arrays.fill(pred, -1);
            boolean[] inQueue = new boolean[numVertices];
            int[] visitCnt = new int[numVertices];
            boolean negativeWeightCycleDetected = false;
            d[sourceIndex] = 0.0;
            LinkedList<Integer> q = new LinkedList<Integer>();
            q.add(sourceIndex);
            inQueue[sourceIndex] = true;
            while (!q.isEmpty()) {
                u = (Integer)q.poll();
                inQueue[u] = false;
                if (visitCnt[u] > numVertices) {
                    negativeWeightCycleDetected = true;
                    break;
                }
                for (Pair edge : this.edges.get(u)) {
                    v = edge.target;
                    weight = edge.weight;
                    if (!(d[v] > d[u] + weight + 1.0E-9)) continue;
                    d[v] = d[u] + weight;
                    pred[v] = u;
                    if (inQueue[v]) continue;
                    q.add(v);
                    inQueue[v] = true;
                    int n = v;
                    visitCnt[n] = visitCnt[n] + 1;
                }
            }
            if (negativeWeightCycleDetected) {
                while (!q.isEmpty()) {
                    u = (Integer)q.poll();
                    inQueue[u] = false;
                    for (Pair edge : this.edges.get(u)) {
                        v = edge.target;
                        weight = edge.weight;
                        if (!(d[v] > d[u] + weight + 1.0E-9)) continue;
                        pred[v] = u;
                        throw new NegativeCycleDetectedException(GRAPH_CONTAINS_NEGATIVE_WEIGHT_CYCLE, this.computeNegativeCycle(pred, v));
                    }
                }
            }
            HashMap<Task, Double> results = new HashMap<Task, Double>();
            for (Map.Entry<Task, Integer> entry : this.vertexToIndex.entrySet()) {
                results.put(entry.getKey(), scale * d[entry.getValue()]);
            }
            return results;
        }

        private List<Task> computeNegativeCycle(int[] pred, int start) {
            HashSet<Integer> visited = new HashSet<Integer>();
            visited.add(start);
            int cur = pred[start];
            while (!visited.contains(cur)) {
                visited.add(cur);
                cur = pred[cur];
            }
            ArrayList<Task> cycle = new ArrayList<Task>();
            start = cur;
            do {
                cycle.add(this.indexToVertex.get(cur));
            } while ((cur = pred[cur]) != start);
            Collections.reverse(cycle);
            return cycle;
        }

        public class NegativeCycleDetectedException
        extends RuntimeException {
            private static final long serialVersionUID = -5497793361920910984L;
            private final List<Task> cycle;

            public NegativeCycleDetectedException(String message, List<Task> cycle) {
                super(message);
                this.cycle = cycle;
            }

            public List<Task> getCycle() {
                return this.cycle;
            }
        }

        class Pair {
            int target;
            double weight;

            public Pair(int target, double weight) {
                this.target = target;
                this.weight = weight;
            }
        }
    }

    private static enum SchedulingType {
        ASAP,
        ALAP;

    }
}

