/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.consolelog;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class FileHyperlink
implements IHyperlink {
    private IFileStore file;
    private int line;

    public FileHyperlink(IFileStore file, int line) {
        this.file = file;
        this.line = line;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        block7: {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = null;
            try {
                editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)this.file);
                if (this.line <= 0) break block7;
                ITextEditor textEditor = null;
                textEditor = editorPart instanceof ITextEditor ? (ITextEditor)editorPart : (ITextEditor)editorPart.getAdapter(ITextEditor.class);
                if (textEditor == null) break block7;
                IEditorInput input = editorPart.getEditorInput();
                IDocumentProvider provider = textEditor.getDocumentProvider();
                try {
                    provider.connect((Object)input);
                }
                catch (CoreException e) {
                    return;
                }
                IDocument document = provider.getDocument((Object)input);
                int offset = -1;
                int length = -1;
                try {
                    IRegion region = document.getLineInformation(this.line - 1);
                    offset = region.getOffset();
                    length = region.getLength();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                provider.disconnect((Object)input);
                if (offset >= 0 && length >= 0) {
                    textEditor.selectAndReveal(offset, length);
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }
}

