/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.ClasspathShortener;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.StandardVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class Standard11xVMRunner
extends StandardVMRunner {
    public Standard11xVMRunner(IVMInstall vmInstance) {
        super(vmInstance);
    }

    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int i;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)LaunchingMessages.StandardVMRunner_Launching_VM____1, (int)2);
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Constructing_command_line____2);
        String program = this.constructProgramString(config);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program);
        String[] vmArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(vmArgs, arguments);
        String[] bootCP = config.getBootClassPath();
        String[] classPath = config.getClassPath();
        String[] combinedPath = null;
        if (bootCP == null) {
            LibraryLocation[] locs = JavaRuntime.getLibraryLocations(this.fVMInstance);
            bootCP = new String[locs.length];
            i = 0;
            while (i < locs.length) {
                bootCP[i] = locs[i].getSystemLibraryPath().toOSString();
                ++i;
            }
        }
        combinedPath = new String[bootCP.length + classPath.length];
        int offset = 0;
        i = 0;
        while (i < bootCP.length) {
            combinedPath[offset] = bootCP[i];
            ++offset;
            ++i;
        }
        i = 0;
        while (i < classPath.length) {
            combinedPath[offset] = classPath[i];
            ++offset;
            ++i;
        }
        if (combinedPath.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(combinedPath));
        }
        arguments.add(config.getClassToLaunch());
        String[] programArgs = config.getProgramArguments();
        String[] envp = this.prependJREPath(config.getEnvironment());
        int lastVMArgumentIndex = arguments.size() - 1;
        this.addArguments(programArgs, arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        if (subMonitor.isCanceled()) {
            return;
        }
        File workingDir = this.getWorkingDir(config);
        ClasspathShortener classpathShortener = new ClasspathShortener(this.fVMInstance, launch, cmdLine, lastVMArgumentIndex, workingDir, envp);
        if (classpathShortener.shortenCommandLineIfNecessary()) {
            cmdLine = classpathShortener.getCmdLine();
            envp = classpathShortener.getEnvp();
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Starting_virtual_machine____3);
        Process p = null;
        String[] newCmdLine = this.validateCommandLine(launch.getLaunchConfiguration(), cmdLine);
        if (newCmdLine != null) {
            cmdLine = newCmdLine;
        }
        if ((p = this.exec(cmdLine, workingDir, envp)) == null) {
            return;
        }
        if (subMonitor.isCanceled()) {
            p.destroy();
            return;
        }
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)Standard11xVMRunner.renderProcessLabel(p, cmdLine, timestamp));
        process.setAttribute("org.eclipse.debug.core.ATTR_PATH", cmdLine[0]);
        process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
        String ltime = launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        process.setAttribute("org.eclipse.debug.core.launch.timestamp", ltime != null ? ltime : timestamp);
        if (workingDir != null) {
            process.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", workingDir.getAbsolutePath());
        }
        if (!classpathShortener.getProcessTempFiles().isEmpty()) {
            String tempFiles = classpathShortener.getProcessTempFiles().stream().map(file -> file.getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
            process.setAttribute("tempFiles", tempFiles);
        }
        subMonitor.worked(1);
    }
}

