/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.util.BoundedLruCache;
import org.eclipse.handly.util.LruCache;
import org.eclipse.handly.util.ToStringOptions;

public class ElementCache
extends BoundedLruCache<IElement, Object> {
    private double loadFactor = 0.3333333333333333;
    private IElement maxSizeParent;

    public ElementCache(int maxSize) {
        super(maxSize);
    }

    public int getOverflow() {
        int overflow = this.size() - this.maxSize();
        if (overflow < 0) {
            return 0;
        }
        return overflow;
    }

    public double getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor > 1.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
    }

    public void ensureMaxSize(int childCount, IElement parent) {
        if (childCount < 0) {
            throw new IllegalArgumentException();
        }
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        int sizeNeeded = 1 + (int)((1.0 + this.getLoadFactor()) * (double)(childCount + this.getOverflow()));
        if (this.maxSize() < sizeNeeded) {
            this.setMaxSize(sizeNeeded);
            this.maxSizeParent = parent;
        }
    }

    public void resetMaxSize(int maxSize, IElement parent) {
        if (parent.equals(this.maxSizeParent)) {
            this.setMaxSize(maxSize);
            this.maxSizeParent = null;
        }
    }

    @Override
    public String toString() {
        LruCache.Entry e = this.getMruEntry();
        if (e == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            sb.append(Elements.toString((IElement)e.key, Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM)));
            e = e.next();
            if (e == null) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    protected void makeSpace(int sizeNeeded) {
        super.makeSpace(this.applyLoadFactor(sizeNeeded));
    }

    private int applyLoadFactor(int sizeNeeded) {
        return Math.max(sizeNeeded, (int)((1.0 - this.getLoadFactor()) * (double)this.maxSize()));
    }

    @Override
    protected void evict(LruCache.Entry<IElement, Object> entry) {
        ((IElementImplExtension)entry.key).close_(Contexts.of(IElementImplExtension.CLOSE_HINT, IElementImplExtension.CloseHint.CACHE_OVERFLOW));
    }
}

