/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;

public abstract class OutlineActionContribution
extends OutlineContribution {
    private ActionContributionItem item;
    private IContributionManager manager;

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        IAction action = this.createAction();
        if (action != null) {
            this.item = new ActionContributionItem(action);
            this.manager = this.getContributionManager();
            this.contribute(this.item, this.manager);
        }
    }

    @Override
    public void dispose() {
        if (this.item != null) {
            if (this.manager != null) {
                this.manager.remove((IContributionItem)this.item);
                this.manager = null;
            }
            this.disposeAction(this.item.getAction());
            this.item.dispose();
            this.item = null;
        }
        super.dispose();
    }

    protected abstract IAction createAction();

    protected void disposeAction(IAction action) {
    }

    protected IContributionManager getContributionManager() {
        return this.getOutlinePage().getSite().getActionBars().getToolBarManager();
    }

    protected void contribute(ActionContributionItem item, IContributionManager manager) {
        manager.add((IContributionItem)item);
    }
}

