/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.ui.callhierarchy.CallTextInfo;
import org.eclipse.handly.ui.callhierarchy.ICallLocation;
import org.eclipse.handly.util.TextRange;

public final class CallLocation
implements ICallLocation {
    private final Object caller;
    private final Object callee;
    private final String callText;
    private final TextRange callRange;
    private final int lineNumber;
    private final ISnapshot snapshot;

    public CallLocation(Object caller, Object callee, String callText, TextRange callRange, int lineNumber, ISnapshot snapshot) {
        if (callText == null) {
            throw new IllegalArgumentException();
        }
        if (lineNumber < 0 && lineNumber != -1) {
            throw new IllegalArgumentException();
        }
        this.caller = caller;
        this.callee = callee;
        this.callText = callText;
        this.callRange = callRange;
        this.lineNumber = lineNumber;
        this.snapshot = snapshot;
    }

    public CallLocation(Object caller, Object callee, CallTextInfo info) {
        this(caller, callee, info.getCallText(), info.getCallRange(), info.getLineNumber(), info.getSnapshot());
    }

    @Override
    public Object getCaller() {
        return this.caller;
    }

    @Override
    public Object getCallee() {
        return this.callee;
    }

    @Override
    public String getCallText() {
        return this.callText;
    }

    @Override
    public TextRange getCallRange() {
        return this.callRange;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public ISnapshot getSnapshot() {
        return this.snapshot;
    }
}

