/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import com.google.common.base.Strings;
import junit.framework.TestCase;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.ElementDelta;
import org.eclipse.handly.model.impl.support.SimpleElement;
import org.eclipse.handly.model.impl.support.SimpleModelManager;

public class ElementDeltaPerformanceTest
extends TestCase {
    private SimpleElement root;
    private SimpleElement[] leafs;
    private ElementDelta delta;

    protected void setUp() throws Exception {
        super.setUp();
        this.root = new SimpleElement(null, "root", new SimpleModelManager());
        ElementDelta.Builder builder = new ElementDelta.Builder(new ElementDelta((IElement)this.root));
        this.leafs = new SimpleElement[10000];
        int i = 0;
        while (i < this.leafs.length) {
            String path = Strings.padStart((String)String.valueOf(i), (int)4, (char)'0');
            builder.added((IElement)ElementDeltaPerformanceTest.getChild(this.root, path));
            this.leafs[i] = ElementDeltaPerformanceTest.getChild(this.root, path);
            ++i;
        }
        this.delta = builder.getDelta();
    }

    public void testFindDeltaPerformance() {
        int i = 0;
        while (i < this.leafs.length) {
            ElementDelta found = this.delta.findDelta_((IElement)this.leafs[i]);
            ElementDeltaPerformanceTest.assertNotNull((Object)found);
            ElementDeltaPerformanceTest.assertEquals((Object)((Object)this.leafs[i]), (Object)found.getElement_());
            ElementDeltaPerformanceTest.assertEquals((int)1, (int)found.getKind_());
            ++i;
        }
    }

    private static SimpleElement getChild(SimpleElement root, String path) {
        SimpleElement child = root;
        int i = 0;
        while (i < path.length()) {
            child = child.getChild(Character.toString(path.charAt(i)));
            ++i;
        }
        return child;
    }
}

