/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.ResourceChangeListenerContribution;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class ProblemMarkerListenerContribution
extends ResourceChangeListenerContribution {
    @Override
    protected void resourceChanged(IResourceChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer treeViewer = ProblemMarkerListenerContribution.this.getOutlinePage().getTreeViewer();
                if (!treeViewer.getControl().isDisposed()) {
                    treeViewer.refresh();
                }
            }
        });
    }

    @Override
    protected boolean affects(IResourceChangeEvent event, Object inputElement) {
        IElement element;
        IResource resource = inputElement instanceof IResource ? (IResource)inputElement : ((element = this.getContentAdapter().adapt(inputElement)) != null ? Elements.getResource((IElement)element) : ResourceUtil.getResource((Object)inputElement));
        if (resource == null) {
            return false;
        }
        IResourceDelta delta = event.getDelta().findMember(resource.getFullPath());
        if (delta == null) {
            return false;
        }
        return this.hasProblemMarkerChanges(delta);
    }

    protected boolean hasProblemMarkerChanges(IResourceDelta delta) {
        if ((delta.getFlags() & 0x20000) != 0) {
            IMarkerDelta[] markerDeltas;
            IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
            int n = markerDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                if (markerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    int kind = markerDelta.getKind();
                    if (kind == 1 || kind == 2) {
                        return true;
                    }
                    int severity = markerDelta.getAttribute("severity", -1);
                    int newSeverity = markerDelta.getMarker().getAttribute("severity", -1);
                    if (newSeverity != severity) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    protected IContentAdapter getContentAdapter() {
        ICommonOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage instanceof IContentAdapterProvider) {
            return ((IContentAdapterProvider)outlinePage).getContentAdapter();
        }
        return NullContentAdapter.INSTANCE;
    }
}

