/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.Messages;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;

public class EditorOpener {
    private final IWorkbenchPage page;
    private final EditorUtility editorUtility;
    private IEditorReference reusedEditorRef;

    public EditorOpener(IWorkbenchPage page, EditorUtility editorUtility) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        if (editorUtility == null) {
            throw new IllegalArgumentException();
        }
        this.page = page;
        this.editorUtility = editorUtility;
    }

    public final IWorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    public final EditorUtility getEditorUtility() {
        return this.editorUtility;
    }

    public IEditorPart open(Object element, boolean activate, boolean reveal) throws PartInitException {
        IEditorPart editor;
        IEditorPart editor2;
        if (element == null) {
            throw new IllegalArgumentException();
        }
        IEditorReference editorRef = this.editorUtility.findEditor(this.page, element);
        if (editorRef != null && (editor2 = editorRef.getEditor(true)) != null) {
            if (activate) {
                this.page.activate((IWorkbenchPart)editor2);
            } else {
                this.page.bringToTop((IWorkbenchPart)editor2);
            }
            if (reveal) {
                this.editorUtility.revealElement(editor2, element);
            }
            return editor2;
        }
        IEditorInput input = this.editorUtility.getEditorInput(element);
        if (input == null) {
            throw new PartInitException(Messages.EditorOpener_No_editor_input);
        }
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        IEditorDescriptor descriptor = file != null ? IDE.getEditorDescriptor((IFile)file, (boolean)true, (boolean)true) : IDE.getEditorDescriptor((String)input.getName(), (boolean)true, (boolean)true);
        String editorId = descriptor.getId();
        if (this.shouldReuseEditor() && this.reusedEditorRef != null) {
            boolean canBeReused;
            editor = this.reusedEditorRef.getEditor(false);
            boolean bl = canBeReused = editor instanceof IReusableEditor && !this.reusedEditorRef.isDirty() && !this.reusedEditorRef.isPinned();
            if (canBeReused) {
                if (!this.reusedEditorRef.getId().equals(editorId)) {
                    this.page.closeEditors(new IEditorReference[]{this.reusedEditorRef}, false);
                } else {
                    ((IReusableEditor)editor).setInput(input);
                    if (activate) {
                        this.page.activate((IWorkbenchPart)editor);
                    } else {
                        this.page.bringToTop((IWorkbenchPart)editor);
                    }
                    if (reveal) {
                        this.editorUtility.revealElement(editor, element);
                    }
                    return editor;
                }
            }
        }
        if ((editor = this.page.openEditor(input, editorId, activate)) != null && reveal) {
            this.editorUtility.revealElement(editor, element);
        }
        this.reusedEditorRef = editor instanceof IReusableEditor ? (IEditorReference)this.page.getReference((IWorkbenchPart)editor) : null;
        return editor;
    }

    protected boolean shouldReuseEditor() {
        return false;
    }
}

