/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.handly.xtext.ui.editor.HandlyDirtyStateEditorSupport;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;

public class HandlyJvmTypesAwareDirtyStateEditorSupport
extends HandlyDirtyStateEditorSupport {
    private static final URI OBJECTS_URI = URI.createURI((String)"java:/Objects");

    protected void processDelta(IResourceDescription.Delta delta, Resource context, List<Resource> result) {
        super.processDelta(delta, context, result);
        ResourceSet resourceSet = context.getResourceSet();
        if (delta.getNew() != null) {
            Iterable exportedJvmTypes = delta.getNew().getExportedObjectsByType(TypesPackage.Literals.JVM_GENERIC_TYPE);
            for (IEObjectDescription jvmTypeDesc : exportedJvmTypes) {
                URI uriToJvmType = OBJECTS_URI.appendSegment(jvmTypeDesc.getQualifiedName().toString());
                Resource jvmResourceInResourceSet = resourceSet.getResource(uriToJvmType, false);
                if (jvmResourceInResourceSet == null) continue;
                result.add(jvmResourceInResourceSet);
            }
        }
    }
}

